/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.space;

import com.gigaspaces.cli.commands.GigaSpacesRestCommand;
import com.gigaspaces.cli.commands.output.ConsoleOutput;
import com.gigaspaces.cli.commands.output.Output;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.api.SpacesApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.SpaceInstance;
import java.util.HashSet;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="list-instances", header={"Lists the instances of the specified Space"})
public class SpaceListInstancesCommand
extends GigaSpacesRestCommand {
    @CommandLine.Parameters(index="0", description={"Name of Space to list instances"})
    String name;
    private static final String[] headersList = new String[]{"Instance ID", "Mode", "Suspend Type", "Host ID", "Container ID"};

    protected void execute() throws Exception {
        try {
            HashSet<String> uniqueContainers;
            HashSet<String> uniqueHosts;
            int totalBackups;
            int totalPrimaries;
            List responseData;
            Output output;
            ApiResponse response = new SpacesApi().spacesIdInstancesGetWithHttpInfo(this.name);
            if (response.getStatusCode() == 200) {
                output = new Output();
                output.addColumns(headersList);
                responseData = (List)response.getData();
                totalPrimaries = 0;
                totalBackups = 0;
                uniqueHosts = new HashSet<String>();
                uniqueContainers = new HashSet<String>();
                for (SpaceInstance spaceInstance : responseData) {
                    output.addRow(spaceInstance.getId(), spaceInstance.getMode(), spaceInstance.getSuspendInfo().getSuspendType().name(), spaceInstance.getHostId(), spaceInstance.getContainerId());
                    totalPrimaries += spaceInstance.getMode().equals("PRIMARY") ? 1 : 0;
                    totalBackups += spaceInstance.getMode().equals("BACKUP") ? 1 : 0;
                    uniqueHosts.add(spaceInstance.getHostId());
                    uniqueContainers.add(spaceInstance.getContainerId());
                }
            } else {
                throw CliManagerUtils.getHttpFailureException(response);
            }
            ConsoleOutput.newline();
            ConsoleOutput.println(output);
            Output sumOutput = new Output();
            sumOutput.addColumn("SUMMARY");
            sumOutput.addRow("Instances:", String.valueOf(responseData.size())).addRow("Primaries:", String.valueOf(totalPrimaries)).addRow("Backups:", String.valueOf(totalBackups)).addRow("Hosts:", String.valueOf(uniqueHosts.size())).addRow("Containers:", String.valueOf(uniqueContainers.size()));
            ConsoleOutput.newline();
            ConsoleOutput.println(sumOutput);
        }
        catch (ApiException e) {
            throw CliManagerUtils.createThrownException((Exception)((Object)e));
        }
    }
}

