/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.space;

import com.gigaspaces.cli.commands.GigaSpacesRestCommand;
import com.gigaspaces.cli.commands.output.ConsoleOutput;
import com.gigaspaces.cli.commands.output.Output;
import com.gigaspaces.cli.commands.utils.CliManagerUtils;
import com.gigaspaces.rest.client.java.api.SpacesApi;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.SpaceQueryResult;
import com.gigaspaces.rest.client.java.model.StringCollection;
import java.util.List;
import picocli.CommandLine;

@CommandLine.Command(name="query", header={"Queries data in a space or a space instance"})
public class SpaceQueryCommand
extends GigaSpacesRestCommand {
    @CommandLine.Parameters(index="0", description={"Space or space instance to query"})
    String id;
    @CommandLine.Parameters(index="1", description={"Name of type to query"})
    String typeName;
    @CommandLine.Option(names={"--filter"}, description={"Predicate to filter results by (e.g. \"name = 'John' AND age > 21\")"})
    String filter;
    @CommandLine.Option(names={"--columns"}, description={"Columns to retrieve"})
    List<String> columns;
    @CommandLine.Option(names={"--max-results"}, description={"Maximum number of rows to retrieve"})
    Integer maxResults;

    protected void execute() throws Exception {
        try {
            Output output;
            SpaceQueryResult responseData;
            ApiResponse<SpaceQueryResult> response = this.executeQuery();
            if (response.getStatusCode() == 200) {
                responseData = (SpaceQueryResult)response.getData();
                output = new Output().upperCaseColumns(false);
                output.addColumns(responseData.getColumns());
                for (StringCollection row : responseData.getResults()) {
                    output.addRow(row.getValues());
                }
            } else {
                throw CliManagerUtils.getHttpFailureException(response);
            }
            ConsoleOutput.newline();
            ConsoleOutput.println(output);
            Output sumOutput = new Output();
            sumOutput.addColumn("SUMMARY");
            sumOutput.addRow("Results:", String.valueOf(responseData.getResults().size()) + (responseData.isHasMore() != false ? " (max reached, more available)" : ""));
            ConsoleOutput.newline();
            ConsoleOutput.println(sumOutput);
        }
        catch (ApiException e) {
            throw CliManagerUtils.createThrownException((Exception)((Object)e));
        }
    }

    private ApiResponse<SpaceQueryResult> executeQuery() throws ApiException {
        int pos = this.id.indexOf(126);
        return pos == -1 ? new SpacesApi().spacesIdQueryGetWithHttpInfo(this.id, this.typeName, this.filter, this.columns, this.maxResults) : new SpacesApi().spacesIdInstancesInstanceIdQueryGetWithHttpInfo(this.id.substring(0, pos), this.id, this.typeName, this.filter, this.columns, this.maxResults);
    }
}

