/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.cli.commands.utils;

import com.gigaspaces.cli.commands.XapPremiumMainCommand;
import com.gigaspaces.cli.commands.output.ConsoleOutput;
import com.gigaspaces.cli.commands.output.Output;
import com.gigaspaces.rest.client.java.invoker.ApiException;
import com.gigaspaces.rest.client.java.invoker.ApiResponse;
import com.gigaspaces.rest.client.java.model.ProcessingUnitInstanceContainer;
import com.gigaspaces.rest.client.java.model.ProcessingUnitTopology;
import com.gigaspaces.rest.client.java.model.QuiesceDetails;
import com.gigaspaces.rest.client.java.model.SpaceTypeStatistics;
import com.gigaspaces.start.SystemInfo;
import com.gigaspaces.start.manager.XapManagerConfig;
import java.io.IOException;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gigaspaces.cli.CliCommandException;
import org.gigaspaces.cli.CliExecutor;

public class CliManagerUtils {
    private static DecimalFormat longNumDecimalFormat = new DecimalFormat("#,##0");
    private static final DecimalFormat decimalFormat = new DecimalFormat();

    public static Exception createThrownException(Exception caughtException) {
        Exception resultException;
        if (caughtException.getCause() instanceof ConnectException) {
            resultException = new CliCommandException(caughtException.getCause().getMessage()).exitCode(2);
            resultException.initCause(caughtException);
        } else if (caughtException instanceof ApiException) {
            ApiException apiException = (ApiException)((Object)caughtException);
            String message = apiException.getMessage();
            String response = apiException.getResponseBody();
            if (response != null) {
                message = message + "#" + apiException.getCode() + " \u00b7 " + response;
            }
            resultException = new CliCommandException(message).exitCode(1);
            resultException.initCause(caughtException);
        } else {
            resultException = caughtException;
        }
        return resultException;
    }

    public static Exception getHttpFailureException(ApiResponse response) {
        String errorMsg = "Unexpected HTTP response code: " + response.getStatusCode();
        return new CliCommandException(errorMsg).exitCode(3);
    }

    public static String getZonesPresentation(ProcessingUnitInstanceContainer gsc) {
        List zones = gsc.getZones();
        return CliManagerUtils.getObjectsTextPresentation(zones);
    }

    public static String getObjectsTextPresentation(List<String> objects) {
        int objectsCount = objects.size();
        StringBuilder stringBuilder = new StringBuilder();
        for (int index = 0; index < objectsCount; ++index) {
            if (index != 0) {
                stringBuilder.append(",");
            }
            stringBuilder.append(objects.get(index));
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("-");
        }
        return stringBuilder.toString();
    }

    public static String createQuiesceDetailsPresentation(QuiesceDetails quiesceDetails) {
        Boolean quiesced = quiesceDetails.isQuiesced();
        String description = quiesceDetails.getDescription();
        return quiesced + " " + (description != null && !description.isEmpty() ? "[" + description + "]" : "");
    }

    public static String createTopologyPresentation(ProcessingUnitTopology topology) {
        String topologyPresentation = "";
        ProcessingUnitTopology.SchemaEnum schema = topology.getSchema();
        Integer partitions = topology.getPartitions();
        Integer backupsPerPartition = topology.getBackupsPerPartition();
        Integer instances = topology.getInstances();
        if (schema != null) {
            if (partitions != null && backupsPerPartition != null) {
                topologyPresentation = topologyPresentation + schema + " " + partitions + "," + backupsPerPartition;
            } else if (instances != null) {
                topologyPresentation = topologyPresentation + schema + " " + instances;
            }
        } else {
            topologyPresentation = "-";
        }
        return topologyPresentation;
    }

    public static String createDurationPresentation(long timeDuration) {
        StringBuilder result = new StringBuilder();
        long seconds = timeDuration / 1000L % 60L;
        long minutes = timeDuration / 60000L % 60L;
        long hours = timeDuration / 3600000L % 24L;
        long days = timeDuration / 86400000L;
        if (days > 0L) {
            result.append(days);
            result.append(days == 1L ? " day, " : " days, ");
        }
        if (hours > 0L) {
            result.append(hours);
            result.append(hours == 1L ? " hour, " : " hours, ");
        }
        if (minutes > 0L) {
            result.append(minutes);
            result.append(minutes == 1L ? " minute, " : " minutes, ");
        }
        result.append(seconds);
        result.append(seconds == 1L ? " second" : " seconds");
        return result.toString();
    }

    public static int getPlannedInstances(ProcessingUnitTopology topology) {
        Integer partitions = topology.getPartitions();
        Integer backupsPerPartition = topology.getBackupsPerPartition();
        Integer instances = topology.getInstances();
        if (partitions != null && backupsPerPartition != null) {
            return partitions * (backupsPerPartition + 1);
        }
        return instances;
    }

    public static void printSpaceTypeTable(String tableName, Set<Map.Entry<String, SpaceTypeStatistics>> entries) {
        ConsoleOutput.newline();
        ConsoleOutput.print(new Output().addColumn(tableName));
        String prefix = " ";
        Output output = new Output();
        output.addColumns(" DATA TYPE NAME", "OBJECTS COUNT", "TEMPLATES COUNT");
        for (Map.Entry<String, SpaceTypeStatistics> entry : entries) {
            String key = entry.getKey();
            SpaceTypeStatistics spaceTypeStatistics = entry.getValue();
            output.addRow(" " + key, longNumDecimalFormat.format(spaceTypeStatistics.getEntries()), longNumDecimalFormat.format(spaceTypeStatistics.getNotifyTemplates()));
        }
        ConsoleOutput.print(output);
    }

    public static String retrieveSpaceName(String spaceInstanceId) throws ApiException {
        return CliManagerUtils.retrieveName(spaceInstanceId);
    }

    public static String retrievePuName(String puInstanceId) throws ApiException {
        return CliManagerUtils.retrieveName(puInstanceId);
    }

    public static String retrieveName(String instanceId) throws ApiException {
        String delimiter = System.getProperty("com.gs.instance-id.delimiter", "~");
        int index = instanceId.indexOf(delimiter);
        if (index < 0) {
            throw new ApiException("Unable to find delimiter [" + delimiter + "] within instance ID [" + instanceId + "]");
        }
        return instanceId.substring(0, index);
    }

    public static String getRestBasePath() {
        String port;
        XapManagerConfig server;
        XapPremiumMainCommand mainCommand = (XapPremiumMainCommand)((Object)CliExecutor.getMainCommand().getCommand());
        String serverOption = mainCommand.getServer();
        if (serverOption != null && !serverOption.isEmpty()) {
            int pos = serverOption.indexOf(58);
            server = new XapManagerConfig(pos == -1 ? serverOption : serverOption.substring(0, pos));
            port = pos != -1 ? serverOption.substring(pos + 1) : server.getAdminRest();
        } else {
            XapManagerConfig[] servers = SystemInfo.singleton().getManagerClusterInfo().getServers();
            server = servers.length != 0 ? servers[0] : new XapManagerConfig("localhost");
            port = server.getAdminRest();
        }
        String result = server.getAdminRestUrl(port) + "/v2";
        return result;
    }

    public static String ifMinusOneReturnNA(Long value) {
        return value.intValue() == -1 ? "N/A" : CliManagerUtils.formatLongValue(value);
    }

    public static String formatLongValue(long val) {
        return longNumDecimalFormat.format(val);
    }

    public static String formatDecimalValue(double val) {
        return decimalFormat.format(val);
    }

    public static boolean pingUrl(String url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)new URL(url).openConnection();
        int timeout = 5000;
        connection.setConnectTimeout(5000);
        connection.setReadTimeout(5000);
        connection.setRequestMethod("HEAD");
        int responseCode = connection.getResponseCode();
        return responseCode == 200;
    }

    static {
        decimalFormat.setMaximumFractionDigits(2);
    }
}

