/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.classloader;

import com.gigaspaces.internal.io.BootIOUtils;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jini.rio.boot.LoggableClassLoader;

public class CustomURLClassLoader
extends URLClassLoader
implements LoggableClassLoader {
    protected final Logger logger;
    private final String name;

    public CustomURLClassLoader(String name, URL[] urls, ClassLoader parent) {
        super(urls, parent);
        this.name = name;
        this.logger = Logger.getLogger("com.gigaspaces.classloader." + name);
        if (this.logger.isLoggable(Level.FINE)) {
            StringBuilder sb = new StringBuilder("Created [urls=" + urls.length + "]");
            String prefix = BootIOUtils.NEW_LINE + "\t";
            for (URL url : urls) {
                sb.append(prefix).append(url);
            }
            this.logger.log(Level.FINE, sb.toString());
        }
    }

    public String toString() {
        return super.toString() + " [name=" + this.name + "]";
    }

    @Override
    public String getLogName() {
        return this.name;
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "loadClass(" + name + ")");
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "findClass(" + name + ")");
        }
        return super.findClass(name);
    }

    @Override
    public URL getResource(String name) {
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "getResource(" + name + ")");
        }
        return super.getResource(name);
    }

    @Override
    public URL findResource(String name) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.log(Level.FINE, "findResource(" + name + ")");
        }
        return super.findResource(name);
    }

    public URL[] getSearchPath() {
        return this.getURLs();
    }
}

