/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.io;

import com.gigaspaces.api.InternalApi;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BooleanSupplier;

@InternalApi
public class BootIOUtils {
    private static final byte STRING_NULL = 0;
    private static final byte STRING_UTF = 1;
    private static final byte STRING_OBJECT = 2;
    public static final int UTF_MAX_LENGTH = Short.MAX_VALUE;
    public static final String NEW_LINE = System.getProperty("line.separator");

    public static boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }

    public static String quoteIfContainsSpace(String s) {
        String QUOTE = "\"";
        return s.contains(" ") && !s.startsWith("\"") && !s.endsWith("\"") ? "\"" + s + "\"" : s;
    }

    public static void writeMapStringString(ObjectOutput out, Map<String, String> map) throws IOException {
        if (map == null) {
            out.writeInt(-1);
        } else {
            int length = map.size();
            out.writeInt(length);
            for (Map.Entry<String, String> entry : map.entrySet()) {
                BootIOUtils.writeString(out, entry.getKey());
                BootIOUtils.writeString(out, entry.getValue());
            }
        }
    }

    public static void writeString(ObjectOutput out, String s) throws IOException {
        if (s == null) {
            out.writeByte(0);
        } else if (s.length() < Short.MAX_VALUE) {
            out.writeByte(1);
            out.writeUTF(s);
        } else {
            out.writeByte(2);
            out.writeObject(s);
        }
    }

    public static Map<String, String> readMapStringString(ObjectInput in) throws IOException, ClassNotFoundException {
        HashMap<String, String> map = null;
        int length = in.readInt();
        if (length >= 0) {
            map = new HashMap<String, String>(length);
            for (int i = 0; i < length; ++i) {
                String key = BootIOUtils.readString(in);
                String value = BootIOUtils.readString(in);
                map.put(key, value);
            }
        }
        return map;
    }

    public static String readString(ObjectInput in) throws IOException, ClassNotFoundException {
        byte code = in.readByte();
        switch (code) {
            case 0: {
                return null;
            }
            case 1: {
                String s = in.readUTF();
                return s;
            }
            case 2: {
                Object obj = in.readObject();
                return (String)obj;
            }
        }
        throw new IllegalStateException("Failed to deserialize a string: unrecognized string type code - " + code);
    }

    public static String[] readStringArray(ObjectInput in) throws IOException, ClassNotFoundException {
        String[] array = null;
        int length = in.readInt();
        if (length >= 0) {
            array = new String[length];
            for (int i = 0; i < length; ++i) {
                array[i] = BootIOUtils.readString(in);
            }
        }
        return array;
    }

    public static void writeStringArray(ObjectOutput out, String[] array) throws IOException {
        if (array == null) {
            out.writeInt(-1);
        } else {
            int length = array.length;
            out.writeInt(length);
            for (int i = 0; i < length; ++i) {
                BootIOUtils.writeString(out, array[i]);
            }
        }
    }

    public static File[] listFiles(File dir) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir.getPath() + " is not a directory");
        }
        if (!dir.canRead()) {
            throw new IllegalArgumentException("No read permissions for " + dir.getPath());
        }
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IllegalArgumentException("An unknown i/o error occurred when scanning files in directory " + dir.getPath());
        }
        return files;
    }

    public static File[] listFiles(File dir, FileFilter filter) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir.getPath() + " is not a directory");
        }
        if (!dir.canRead()) {
            throw new IllegalArgumentException("No read permissions for " + dir.getPath());
        }
        File[] files = dir.listFiles(filter);
        if (files == null) {
            throw new IllegalArgumentException("An unknown i/o error occurred when scanning files in directory " + dir.getPath());
        }
        return files;
    }

    public static File[] listFiles(File dir, FilenameFilter filter) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir.getPath() + " is not a directory");
        }
        if (!dir.canRead()) {
            throw new IllegalArgumentException("No read permissions for " + dir.getPath());
        }
        File[] files = dir.listFiles(filter);
        if (files == null) {
            throw new IllegalArgumentException("An unknown i/o error occurred when scanning files in directory " + dir.getPath());
        }
        return files;
    }

    public static String wrapIpv6HostAddressIfNeeded(InetAddress hostAddress) {
        if (!(hostAddress instanceof Inet6Address)) {
            return hostAddress.getHostAddress();
        }
        return "[" + hostAddress.getHostAddress() + "]";
    }

    public static String path(String base, String ... tokens) {
        String result = base.endsWith(File.separator) ? base.substring(0, base.length() - 1) : base;
        for (String token : tokens) {
            result = result + File.separator + token;
        }
        return result;
    }

    public static Long parseStringAsBytes(String property) {
        int pos;
        if (BootIOUtils.isEmpty(property)) {
            return null;
        }
        for (pos = 0; pos < property.length() && Character.isDigit(property.charAt(pos)); ++pos) {
        }
        String prefix = property.substring(0, pos);
        long number = Long.parseLong(prefix);
        String suffix = pos < property.length() ? property.substring(pos) : null;
        int factor = BootIOUtils.parseMemoryUnit(suffix);
        return number * (long)factor;
    }

    private static int parseMemoryUnit(String s) {
        if (s == null) {
            return 1;
        }
        if (s.equalsIgnoreCase("b")) {
            return 1;
        }
        if (s.equalsIgnoreCase("k")) {
            return 1024;
        }
        if (s.equalsIgnoreCase("ki")) {
            return 1024;
        }
        if (s.equalsIgnoreCase("kib")) {
            return 1024;
        }
        if (s.equalsIgnoreCase("kb")) {
            return 1000;
        }
        if (s.equalsIgnoreCase("m")) {
            return 0x100000;
        }
        if (s.equalsIgnoreCase("mi")) {
            return 0x100000;
        }
        if (s.equalsIgnoreCase("mib")) {
            return 0x100000;
        }
        if (s.equalsIgnoreCase("mb")) {
            return 1000000;
        }
        if (s.equalsIgnoreCase("g")) {
            return 0x40000000;
        }
        if (s.equalsIgnoreCase("gi")) {
            return 0x40000000;
        }
        if (s.equalsIgnoreCase("gib")) {
            return 0x40000000;
        }
        if (s.equalsIgnoreCase("gb")) {
            return 1000000000;
        }
        if (s.equalsIgnoreCase("t")) {
            return 0;
        }
        if (s.equalsIgnoreCase("ti")) {
            return 0;
        }
        if (s.equalsIgnoreCase("tib")) {
            return 0;
        }
        if (s.equalsIgnoreCase("tb")) {
            return -727379968;
        }
        throw new IllegalArgumentException("Invalid memory unit: '" + s + "'. Supported units: b, k, ki, kib, kb, m, mi, mib, mb, g, gi, gib, gb, t, ti, tib, tb");
    }

    public static boolean waitFor(BooleanSupplier predicate, long timeout, long pollInterval) throws InterruptedException {
        long deadline = System.currentTimeMillis() + timeout;
        while (!predicate.getAsBoolean()) {
            long currTime = System.currentTimeMillis();
            if (currTime >= deadline) {
                return false;
            }
            Thread.sleep(Math.min(pollInterval, deadline - currTime));
        }
        return true;
    }

    public static boolean tryWaitFor(BooleanSupplier predicate, long timeout, long pollInterval) {
        try {
            return BootIOUtils.waitFor(predicate, timeout, pollInterval);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
    }
}

