/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.jmx;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.management.entry.JMXConnection;
import com.gigaspaces.start.SystemBoot;
import com.gigaspaces.start.SystemInfo;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

@InternalApi
public class JMXUtilities {
    public static JMXConnection createJMXConnectionAttribute(String serviceName) {
        String url = SystemBoot.getJMXServiceURL();
        if (SystemInfo.singleton().network().isPublicHostConfigured()) {
            url = System.getProperty("com.gigaspaces.system.jmxDockerServicePublicURL");
        }
        return url == null ? null : new JMXConnection(url, serviceName + "_" + SystemInfo.singleton().network().getPublicHostId() + "_" + SystemBoot.getRegistryPort());
    }

    public static String createJMXUrl(String hostName, int port) {
        if (JMXUtilities.isHostNameOfIpv6AndNeedsSquareBrackets(hostName)) {
            hostName = "[" + hostName + "]";
        }
        return JMXUtilities.createJMXUrl(hostName + ":" + port);
    }

    private static boolean isHostNameOfIpv6AndNeedsSquareBrackets(String hostName) {
        try {
            InetAddress inetAddress = InetAddress.getByName(hostName);
            return inetAddress instanceof Inet6Address && !hostName.startsWith("[");
        }
        catch (UnknownHostException e) {
            return hostName.contains(":") && !hostName.startsWith("[");
        }
    }

    public static String createJMXUrl(String jndiURL) {
        jndiURL = JMXUtilities.convertJndiURLtoIpV6Compliant(jndiURL);
        return "service:jmx:rmi:///jndi/rmi://" + jndiURL + "/jmxrmi";
    }

    private static String convertJndiURLtoIpV6Compliant(String jndiURL) {
        if (jndiURL.indexOf(":") == jndiURL.lastIndexOf(":")) {
            return jndiURL;
        }
        String hostName = jndiURL.substring(0, jndiURL.lastIndexOf(":"));
        if (!JMXUtilities.isHostNameOfIpv6AndNeedsSquareBrackets(hostName)) {
            return jndiURL;
        }
        String port = jndiURL.substring(jndiURL.lastIndexOf(":") + 1);
        return "[" + hostName + "]:" + port;
    }
}

