/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.jmx;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.jvm.JVMStatisticsProbe;
import com.gigaspaces.internal.oshi.OshiChecker;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;
import oshi.SystemInfo;
import oshi.software.os.OSProcess;
import oshi.software.os.OperatingSystem;

@InternalApi
public class OshiJVMStatisticsProbe
implements JVMStatisticsProbe {
    private static RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private static MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private static ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private static OperatingSystem oshiOperatingSystem;

    @Override
    public JVMStatistics probeStatistics() {
        long gcCollectionCount = 0L;
        long gcCollectionTime = 0L;
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcMxBean : gcMxBeans) {
            long tmp = gcMxBean.getCollectionCount();
            if (tmp != -1L) {
                gcCollectionCount += tmp;
            }
            if ((tmp = gcMxBean.getCollectionTime()) == -1L) continue;
            gcCollectionTime += tmp;
        }
        OSProcess osProcess = oshiOperatingSystem.getProcess(oshiOperatingSystem.getProcessId());
        return new JVMStatistics(System.currentTimeMillis(), runtimeMXBean.getUptime(), memoryMXBean.getHeapMemoryUsage().getCommitted(), memoryMXBean.getHeapMemoryUsage().getUsed(), memoryMXBean.getNonHeapMemoryUsage().getCommitted(), memoryMXBean.getNonHeapMemoryUsage().getUsed(), threadMXBean.getThreadCount(), threadMXBean.getPeakThreadCount(), gcCollectionCount, gcCollectionTime, osProcess.calculateCpuPercent(), osProcess.getKernelTime() + osProcess.getUserTime(), System.currentTimeMillis());
    }

    static {
        SystemInfo oshiSystemInfo = OshiChecker.getSystemInfo();
        oshiOperatingSystem = oshiSystemInfo.getOperatingSystem();
    }
}

