/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.jvm;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.BootIOUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;

@InternalApi
public class JVMDetails
implements Externalizable {
    private static final String ENV_PREFIX = "XAP_";
    private static final String OLD_ENV_PREFIX = "GIGASPACES_";
    private static final long serialVersionUID = -4083973634154614496L;
    private String uid = "";
    private String vmName = "";
    private String vmVersion = "";
    private String vmVendor = "";
    private long startTime = -1L;
    private long memoryHeapInit = -1L;
    private long memoryHeapMax = -1L;
    private long memoryNonHeapInit = -1L;
    private long memoryNonHeapMax = -1L;
    private String[] inputArguments;
    private String bootClassPath;
    private String classPath;
    private Map<String, String> systemProperties;
    private Map<String, String> environmentVariables;
    private long pid = -1L;

    public JVMDetails() {
    }

    public JVMDetails(String uid, String vmName, String vmVersion, String vmVendor, long startTime, long memoryHeapInit, long memoryHeapMax, long memoryNonHeapInit, long memoryNonHeapMax, String[] inputArguments, String bootClassPath, String classPath, Map<String, String> systemProperties, Map<String, String> environmentVariables) {
        this(uid, vmName, vmVersion, vmVendor, startTime, memoryHeapInit, memoryHeapMax, memoryNonHeapInit, memoryNonHeapMax, inputArguments, bootClassPath, classPath, systemProperties, environmentVariables, -1L);
    }

    public JVMDetails(String uid, String vmName, String vmVersion, String vmVendor, long startTime, long memoryHeapInit, long memoryHeapMax, long memoryNonHeapInit, long memoryNonHeapMax, String[] inputArguments, String bootClassPath, String classPath, Map<String, String> systemProperties, Map<String, String> environmentVariables, long pid) {
        this.uid = uid;
        this.vmName = vmName;
        this.vmVersion = vmVersion;
        this.vmVendor = vmVendor;
        this.startTime = startTime;
        this.memoryHeapInit = memoryHeapInit;
        this.memoryHeapMax = memoryHeapMax;
        this.memoryNonHeapInit = memoryNonHeapInit;
        this.memoryNonHeapMax = memoryNonHeapMax;
        this.inputArguments = inputArguments;
        this.bootClassPath = bootClassPath;
        this.classPath = classPath;
        this.systemProperties = systemProperties;
        this.environmentVariables = JVMDetails.filterByPrefix(environmentVariables);
        this.pid = pid;
    }

    private static Map<String, String> filterByPrefix(Map<String, String> map) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String value = entry.getValue();
            String key = entry.getKey();
            if (!key.startsWith(ENV_PREFIX) && !key.startsWith(OLD_ENV_PREFIX)) continue;
            result.put(key, value);
        }
        return result;
    }

    public boolean isNA() {
        return this.uid.length() == 0;
    }

    public String getUid() {
        return this.uid;
    }

    public String getVmName() {
        return this.vmName;
    }

    public String getVmVersion() {
        return this.vmVersion;
    }

    public String getVmVendor() {
        return this.vmVendor;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getMemoryHeapInit() {
        return this.memoryHeapInit;
    }

    public long getMemoryHeapMax() {
        return this.memoryHeapMax;
    }

    public long getMemoryNonHeapInit() {
        return this.memoryNonHeapInit;
    }

    public long getMemoryNonHeapMax() {
        return this.memoryNonHeapMax;
    }

    public String[] getInputArguments() {
        return this.inputArguments;
    }

    public String getBootClassPath() {
        return this.bootClassPath;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public long getPid() {
        return this.pid;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v9_1_1)) {
            this.writeExternal9_1_1(out);
        } else {
            this.writeExternal9_1_0(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        if (version.greaterOrEquals(PlatformLogicalVersion.v9_1_1)) {
            this.readExternal9_1_1(in);
        } else {
            this.readExternal9_1_0(in);
        }
    }

    private void writeExternal9_1_0(ObjectOutput out) throws IOException {
        out.writeUTF(this.uid);
        out.writeUTF(this.vmName);
        out.writeUTF(this.vmVersion);
        out.writeUTF(this.vmVendor);
        out.writeLong(this.startTime);
        out.writeLong(this.memoryHeapInit);
        out.writeLong(this.memoryHeapMax);
        out.writeLong(this.memoryNonHeapInit);
        out.writeLong(this.memoryNonHeapMax);
        out.writeObject(this.inputArguments);
        out.writeUTF(this.bootClassPath);
        out.writeUTF(this.classPath);
        out.writeObject(this.systemProperties);
        out.writeLong(this.pid);
    }

    private void writeExternal9_1_1(ObjectOutput out) throws IOException {
        BootIOUtils.writeString(out, this.uid);
        BootIOUtils.writeString(out, this.vmName);
        BootIOUtils.writeString(out, this.vmVersion);
        BootIOUtils.writeString(out, this.vmVendor);
        out.writeLong(this.startTime);
        out.writeLong(this.memoryHeapInit);
        out.writeLong(this.memoryHeapMax);
        out.writeLong(this.memoryNonHeapInit);
        out.writeLong(this.memoryNonHeapMax);
        BootIOUtils.writeStringArray(out, this.inputArguments);
        BootIOUtils.writeString(out, this.bootClassPath);
        BootIOUtils.writeString(out, this.classPath);
        BootIOUtils.writeMapStringString(out, this.systemProperties);
        out.writeLong(this.pid);
        BootIOUtils.writeMapStringString(out, this.environmentVariables);
    }

    private void readExternal9_1_0(ObjectInput in) throws IOException, ClassNotFoundException {
        this.uid = in.readUTF();
        this.vmName = in.readUTF();
        this.vmVersion = in.readUTF();
        this.vmVendor = in.readUTF();
        this.startTime = in.readLong();
        this.memoryHeapInit = in.readLong();
        this.memoryHeapMax = in.readLong();
        this.memoryNonHeapInit = in.readLong();
        this.memoryNonHeapMax = in.readLong();
        this.inputArguments = (String[])in.readObject();
        this.bootClassPath = in.readUTF();
        this.classPath = in.readUTF();
        this.systemProperties = (Map)in.readObject();
        this.pid = in.readLong();
    }

    private void readExternal9_1_1(ObjectInput in) throws IOException, ClassNotFoundException {
        this.uid = BootIOUtils.readString(in);
        this.vmName = BootIOUtils.readString(in);
        this.vmVersion = BootIOUtils.readString(in);
        this.vmVendor = BootIOUtils.readString(in);
        this.startTime = in.readLong();
        this.memoryHeapInit = in.readLong();
        this.memoryHeapMax = in.readLong();
        this.memoryNonHeapInit = in.readLong();
        this.memoryNonHeapMax = in.readLong();
        this.inputArguments = BootIOUtils.readStringArray(in);
        this.bootClassPath = BootIOUtils.readString(in);
        this.classPath = BootIOUtils.readString(in);
        this.systemProperties = BootIOUtils.readMapStringString(in);
        this.pid = in.readLong();
        this.environmentVariables = BootIOUtils.readMapStringString(in);
    }
}

