/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.jvm;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.jmx.OshiJVMDetailsProbe;
import com.gigaspaces.internal.jmx.OshiJVMStatisticsProbe;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMDetailsProbe;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.jvm.JVMStatisticsProbe;
import com.gigaspaces.internal.jvm.jmx.JMXJVMDetailsProbe;
import com.gigaspaces.internal.jvm.jmx.JMXJVMStatisticsProbe;
import com.gigaspaces.internal.jvm.sigar.SigarJVMDetailsProbe;
import com.gigaspaces.internal.jvm.sigar.SigarJVMStatisticsProbe;
import com.gigaspaces.internal.oshi.OshiChecker;
import com.gigaspaces.internal.sigar.SigarChecker;
import com.gigaspaces.logger.LogHelper;
import java.util.logging.Level;

@InternalApi
public class JVMHelper {
    private static final String _loggerName = "com.gigaspaces.jvm";
    private static final JVMDetailsProbe _detailsProbe;
    private static final JVMStatisticsProbe _statisticsProbe;
    private static final JVMDetails NA_DETAILS;
    private static final JVMStatistics NA_STATISTICS;
    private static JVMDetails details;

    private static JVMDetailsProbe initJVMDetailsProbe() {
        String detailsProbeClass = System.getProperty("gs.admin.jvm.probe.details");
        if (detailsProbeClass != null) {
            return (JVMDetailsProbe)JVMHelper.tryCreateInstance(detailsProbeClass);
        }
        if (OshiChecker.isAvailable()) {
            OshiJVMDetailsProbe oshiJVMDetailsProbe = new OshiJVMDetailsProbe();
            oshiJVMDetailsProbe.probeDetails();
            return oshiJVMDetailsProbe;
        }
        if (SigarChecker.isAvailable()) {
            try {
                SigarJVMDetailsProbe result = new SigarJVMDetailsProbe();
                result.probeDetails();
                return result;
            }
            catch (Throwable t) {
                LogHelper.log(_loggerName, Level.FINE, "Trying to load sigar failed", t);
            }
        }
        try {
            JMXJVMDetailsProbe result = new JMXJVMDetailsProbe();
            result.probeDetails();
            return result;
        }
        catch (Throwable t) {
            LogHelper.log(_loggerName, Level.FINE, "Trying to load sigar failed", t);
            return null;
        }
    }

    private static JVMStatisticsProbe initJVMStatisticsProbe() {
        String statisticsProbeClass = System.getProperty("gs.admin.jvm.probe.statistics");
        if (statisticsProbeClass != null) {
            return (JVMStatisticsProbe)JVMHelper.tryCreateInstance(statisticsProbeClass);
        }
        if (OshiChecker.isAvailable()) {
            OshiJVMStatisticsProbe oshiJVMStatisticsProbe = new OshiJVMStatisticsProbe();
            oshiJVMStatisticsProbe.probeStatistics();
            return oshiJVMStatisticsProbe;
        }
        if (SigarChecker.isAvailable()) {
            try {
                SigarJVMStatisticsProbe result = new SigarJVMStatisticsProbe();
                result.probeStatistics();
                return result;
            }
            catch (Throwable t) {
                LogHelper.log(_loggerName, Level.FINE, "Trying to load sigar failed", t);
            }
        }
        try {
            JMXJVMStatisticsProbe result = new JMXJVMStatisticsProbe();
            result.probeStatistics();
            return result;
        }
        catch (Throwable t) {
            LogHelper.log(_loggerName, Level.FINE, "Trying to load JMX failed", t);
            return null;
        }
    }

    private static <T> T tryCreateInstance(String className) {
        try {
            Class<?> clazz = JVMHelper.class.getClassLoader().loadClass(className);
            return (T)clazz.newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static JVMDetails getDetails() {
        if (_detailsProbe == null) {
            return NA_DETAILS;
        }
        try {
            if (details != null) {
                return details;
            }
            details = _detailsProbe.probeDetails();
            return details;
        }
        catch (Exception e) {
            LogHelper.log(_loggerName, Level.FINE, "Failed to get configuration", e);
            return NA_DETAILS;
        }
    }

    public static JVMStatistics getStatistics() {
        if (_statisticsProbe == null) {
            return NA_STATISTICS;
        }
        try {
            return _statisticsProbe.probeStatistics();
        }
        catch (Exception e) {
            LogHelper.log(_loggerName, Level.FINE, "Failed to get stats", e);
            return NA_STATISTICS;
        }
    }

    public static void initStaticCotr() {
    }

    static {
        NA_DETAILS = new JVMDetails();
        NA_STATISTICS = new JVMStatistics();
        _statisticsProbe = JVMHelper.initJVMStatisticsProbe();
        _detailsProbe = JVMHelper.initJVMDetailsProbe();
    }
}

