/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.jvm;

import com.gigaspaces.api.InternalApi;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class JVMStatistics
implements Externalizable {
    private static final long serialVersionUID = 1688670775236533438L;
    private long timestamp = -1L;
    private long uptime;
    private long memoryHeapCommitted;
    private long memoryHeapUsed;
    private long memoryNonHeapCommitted;
    private long memoryNonHeapUsed;
    private int threadCount;
    private int peakThreadCount;
    private long gcCollectionCount;
    private long gcCollectionTime;
    private double cpuPerc = -1.0;
    private long cpuTotal = -1L;
    private long cpuTime = -1L;

    public JVMStatistics() {
    }

    public JVMStatistics(long timestamp, long uptime, long memoryHeapCommitted, long memoryHeapUsed, long memoryNonHeapCommitted, long memoryNonHeapUsed, int threadCount, int peakThreadCount, long gcCollectionCount, long gcCollectionTime) {
        this(timestamp, uptime, memoryHeapCommitted, memoryHeapUsed, memoryNonHeapCommitted, memoryNonHeapUsed, threadCount, peakThreadCount, gcCollectionCount, gcCollectionTime, -1.0, -1L, -1L);
    }

    public JVMStatistics(long timestamp, long uptime, long memoryHeapCommitted, long memoryHeapUsed, long memoryNonHeapCommitted, long memoryNonHeapUsed, int threadCount, int peakThreadCount, long gcCollectionCount, long gcCollectionTime, double cpuPerc, long cpuTotal, long cpuTime) {
        this.timestamp = timestamp;
        this.uptime = uptime;
        this.memoryHeapCommitted = memoryHeapCommitted;
        this.memoryHeapUsed = memoryHeapUsed;
        this.memoryNonHeapCommitted = memoryNonHeapCommitted;
        this.memoryNonHeapUsed = memoryNonHeapUsed;
        this.threadCount = threadCount;
        this.peakThreadCount = peakThreadCount;
        this.gcCollectionCount = gcCollectionCount;
        this.gcCollectionTime = gcCollectionTime;
        this.cpuPerc = cpuPerc;
        this.cpuTotal = cpuTotal;
        this.cpuTime = cpuTime;
    }

    public boolean isNA() {
        return this.timestamp == -1L;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getUptime() {
        return this.uptime;
    }

    public long getMemoryHeapCommitted() {
        return this.memoryHeapCommitted;
    }

    public long getMemoryHeapUsed() {
        return this.memoryHeapUsed;
    }

    public long getMemoryNonHeapCommitted() {
        return this.memoryNonHeapCommitted;
    }

    public long getMemoryNonHeapUsed() {
        return this.memoryNonHeapUsed;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public int getPeakThreadCount() {
        return this.peakThreadCount;
    }

    public long getGcCollectionCount() {
        return this.gcCollectionCount;
    }

    public long getGcCollectionTime() {
        return this.gcCollectionTime;
    }

    public double computeCpuPerc(JVMStatistics lastJVMStatistics) {
        if (lastJVMStatistics.getCpuTime() <= 0L || this.getCpuTime() <= 0L) {
            return this.cpuPerc;
        }
        long timeDelta = this.getCpuTime() - lastJVMStatistics.getCpuTime();
        long totalDelta = this.getCpuTotal() - lastJVMStatistics.getCpuTotal();
        if (timeDelta <= 0L || totalDelta < 0L) {
            return -1.0;
        }
        return (double)totalDelta / (double)timeDelta;
    }

    private long getCpuTotal() {
        return this.cpuTotal;
    }

    private long getCpuTime() {
        return this.cpuTime;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.timestamp);
        out.writeLong(this.uptime);
        out.writeLong(this.memoryHeapCommitted);
        out.writeLong(this.memoryHeapUsed);
        out.writeLong(this.memoryNonHeapCommitted);
        out.writeLong(this.memoryNonHeapUsed);
        out.writeInt(this.threadCount);
        out.writeInt(this.peakThreadCount);
        out.writeLong(this.gcCollectionCount);
        out.writeLong(this.gcCollectionTime);
        out.writeLong(this.cpuTotal);
        out.writeLong(this.cpuTime);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.timestamp = in.readLong();
        this.uptime = in.readLong();
        this.memoryHeapCommitted = in.readLong();
        this.memoryHeapUsed = in.readLong();
        this.memoryNonHeapCommitted = in.readLong();
        this.memoryNonHeapUsed = in.readLong();
        this.threadCount = in.readInt();
        this.peakThreadCount = in.readInt();
        this.gcCollectionCount = in.readLong();
        this.gcCollectionTime = in.readLong();
        this.cpuTotal = in.readLong();
        this.cpuTime = in.readLong();
    }
}

