/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.jvm;

import com.gigaspaces.api.InternalApi;

@InternalApi
public class JavaUtils {
    private static final String VENDOR = System.getProperty("java.vendor", "");
    private static final int JAVA_VERSION_MAJOR = JavaUtils.parseJavaMajorVersion();
    private static final boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("win");
    private static final boolean isOsx = System.getProperty("os.name").toLowerCase().startsWith("mac os x");

    private static int parseJavaMajorVersion() {
        int pos;
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2);
        }
        if ((pos = version.indexOf(46)) != -1) {
            version = version.substring(0, pos);
        }
        return Integer.parseInt(version);
    }

    public static int getMajorJavaVersion() {
        return JAVA_VERSION_MAJOR;
    }

    public static boolean greaterOrEquals(int version) {
        return JAVA_VERSION_MAJOR >= version;
    }

    public static boolean isWindows() {
        return isWindows;
    }

    public static boolean isOsx() {
        return isOsx;
    }

    public static void main(String[] args) {
        try {
            String request;
            switch (request = args.length != 0 ? args[0].toLowerCase() : "version") {
                case "version": {
                    System.out.println(JavaUtils.getMajorJavaVersion());
                    break;
                }
                default: {
                    System.out.println("Unsupported: [" + request + "]");
                    break;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Error: " + e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static String getVendor() {
        return VENDOR;
    }
}

