/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.jvm.jmx;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.jvm.JVMDetails;
import com.gigaspaces.internal.jvm.JVMDetailsProbe;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.UUID;

@InternalApi
public class JMXJVMDetailsProbe
implements JVMDetailsProbe {
    private static final String uid = UUID.randomUUID().toString();
    private static RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private static MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private static long pid;

    @Override
    public JVMDetails probeDetails() {
        return new JVMDetails(uid, runtimeMXBean.getVmName(), System.getProperty("java.version"), System.getProperty("java.vendor"), runtimeMXBean.getStartTime(), memoryMXBean.getHeapMemoryUsage().getInit(), memoryMXBean.getHeapMemoryUsage().getMax(), memoryMXBean.getNonHeapMemoryUsage().getInit(), memoryMXBean.getNonHeapMemoryUsage().getMax(), runtimeMXBean.getInputArguments().toArray(new String[0]), runtimeMXBean.isBootClassPathSupported() ? runtimeMXBean.getBootClassPath() : "", runtimeMXBean.getClassPath(), runtimeMXBean.getSystemProperties(), System.getenv(), pid);
    }

    static {
        String pid = runtimeMXBean.getName();
        try {
            pid = pid.split("@")[0];
            JMXJVMDetailsProbe.pid = Long.parseLong(pid);
        }
        catch (Exception e) {
            JMXJVMDetailsProbe.pid = -1L;
        }
    }
}

