/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.jvm.sigar;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.jvm.JVMStatisticsProbe;
import com.gigaspaces.internal.sigar.SigarHolder;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.List;
import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

@InternalApi
public class SigarJVMStatisticsProbe
implements JVMStatisticsProbe {
    private static RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
    private static MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
    private static ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
    private Sigar sigar = SigarHolder.getSigar();

    @Override
    public JVMStatistics probeStatistics() {
        long gcCollectionCount = 0L;
        long gcCollectionTime = 0L;
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcMxBean : gcMxBeans) {
            long tmp = gcMxBean.getCollectionCount();
            if (tmp != -1L) {
                gcCollectionCount += tmp;
            }
            if ((tmp = gcMxBean.getCollectionTime()) == -1L) continue;
            gcCollectionTime += tmp;
        }
        double cpuPerc = 0.0;
        long cpuTotal = 0L;
        long cpuTime = 0L;
        try {
            ProcCpu procCpu = this.sigar.getProcCpu(this.sigar.getPid());
            cpuPerc = procCpu.getPercent();
            cpuTotal = procCpu.getTotal();
            cpuTime = System.currentTimeMillis();
        }
        catch (SigarException e) {
            cpuPerc = -1.0;
            cpuTotal = -1L;
            cpuTime = -1L;
        }
        return new JVMStatistics(System.currentTimeMillis(), runtimeMXBean.getUptime(), memoryMXBean.getHeapMemoryUsage().getCommitted(), memoryMXBean.getHeapMemoryUsage().getUsed(), memoryMXBean.getNonHeapMemoryUsage().getCommitted(), memoryMXBean.getNonHeapMemoryUsage().getUsed(), threadMXBean.getThreadCount(), threadMXBean.getPeakThreadCount(), gcCollectionCount, gcCollectionTime, cpuPerc, cpuTotal, cpuTime);
    }
}

