/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.os;

import com.gigaspaces.api.InternalApi;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class OSDetails
implements Externalizable {
    private static final long serialVersionUID = -290262929223386658L;
    private String uid = "";
    private String name = "";
    private String arch = "";
    private String version = "";
    private int availableProcessors = -1;
    private long totalSwapSpaceSize = -1L;
    private long totalPhysicalMemorySize = -1L;
    private String hostName = "";
    private String hostAddress = "";
    private OSNetInterfaceDetails[] netInterfaceConfigs;
    private OSDriveDetails[] driveConfigs;
    private OSVendorDetails vendorDetails;

    public OSDetails() {
    }

    public OSDetails(String uid, String name, String arch, String version, int availableProcessors, long totalSwapSpaceSize, long totalPhysicalMemorySize, String hostName, String hostAddress, OSNetInterfaceDetails[] netInterfaceConfigs, OSDriveDetails[] driveConfigs, OSVendorDetails vendorDetails) {
        this.uid = uid;
        this.name = name;
        this.arch = arch;
        this.version = version;
        this.availableProcessors = availableProcessors;
        this.totalSwapSpaceSize = totalSwapSpaceSize;
        this.totalPhysicalMemorySize = totalPhysicalMemorySize;
        this.hostName = hostName;
        this.hostAddress = hostAddress;
        this.netInterfaceConfigs = netInterfaceConfigs;
        this.driveConfigs = driveConfigs;
        this.vendorDetails = vendorDetails;
    }

    public boolean isNA() {
        return this.uid.length() == 0;
    }

    public String getUID() {
        return this.uid;
    }

    public String getName() {
        return this.name;
    }

    public String getArch() {
        return this.arch;
    }

    public String getVersion() {
        return this.version;
    }

    public int getAvailableProcessors() {
        return this.availableProcessors;
    }

    public long getTotalSwapSpaceSize() {
        return this.totalSwapSpaceSize;
    }

    public long getTotalPhysicalMemorySize() {
        return this.totalPhysicalMemorySize;
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public OSNetInterfaceDetails[] getNetInterfaceConfigs() {
        return this.netInterfaceConfigs;
    }

    public OSDriveDetails[] getDriveConfigs() {
        return this.driveConfigs;
    }

    public OSVendorDetails getVendorDetails() {
        return this.vendorDetails;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.uid);
        out.writeUTF(this.name);
        out.writeUTF(this.arch);
        out.writeUTF(this.version);
        out.writeInt(this.availableProcessors);
        out.writeLong(this.totalSwapSpaceSize);
        out.writeLong(this.totalPhysicalMemorySize);
        out.writeUTF(this.hostName);
        out.writeUTF(this.hostAddress);
        if (this.netInterfaceConfigs == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.netInterfaceConfigs.length);
            for (Externalizable externalizable : this.netInterfaceConfigs) {
                ((OSNetInterfaceDetails)externalizable).writeExternal(out);
            }
        }
        if (this.driveConfigs == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.driveConfigs.length);
            for (Externalizable externalizable : this.driveConfigs) {
                ((OSDriveDetails)externalizable).writeExternal(out);
            }
        }
        if (this.vendorDetails == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            this.vendorDetails.writeExternal(out);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        this.uid = in.readUTF();
        this.name = in.readUTF();
        this.arch = in.readUTF();
        this.version = in.readUTF();
        this.availableProcessors = in.readInt();
        this.totalSwapSpaceSize = in.readLong();
        this.totalPhysicalMemorySize = in.readLong();
        this.hostName = in.readUTF();
        this.hostAddress = in.readUTF();
        if (in.readBoolean()) {
            this.netInterfaceConfigs = new OSNetInterfaceDetails[in.readInt()];
            for (i = 0; i < this.netInterfaceConfigs.length; ++i) {
                this.netInterfaceConfigs[i] = new OSNetInterfaceDetails();
                this.netInterfaceConfigs[i].readExternal(in);
            }
        }
        if (in.readBoolean()) {
            this.driveConfigs = new OSDriveDetails[in.readInt()];
            for (i = 0; i < this.driveConfigs.length; ++i) {
                this.driveConfigs[i] = new OSDriveDetails();
                this.driveConfigs[i].readExternal(in);
            }
        }
        if (in.readBoolean()) {
            this.vendorDetails = new OSVendorDetails();
            this.vendorDetails.readExternal(in);
        }
    }

    public static class OSVendorDetails
    implements Externalizable {
        private static final long serialVersionUID = 422639202428429664L;
        private String vendor;
        private String vendorCodeName;
        private String vendorName;
        private String vendorVersion;

        public OSVendorDetails() {
        }

        public OSVendorDetails(String vendor, String vendorCodeName, String vendorName, String vendorVersion) {
            this.vendor = vendor;
            this.vendorCodeName = vendorCodeName;
            this.vendorName = vendorName;
            this.vendorVersion = vendorVersion;
        }

        public String getVendor() {
            return this.vendor;
        }

        public String getVendorCodeName() {
            return this.vendorCodeName;
        }

        public String getVendorName() {
            return this.vendorName;
        }

        public String getVendorVersion() {
            return this.vendorVersion;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.vendor = in.readUTF();
            this.vendorCodeName = in.readUTF();
            this.vendorName = in.readUTF();
            this.vendorVersion = in.readUTF();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.vendor);
            out.writeUTF(this.vendorCodeName);
            out.writeUTF(this.vendorName);
            out.writeUTF(this.vendorVersion);
        }
    }

    public static class OSDriveDetails
    implements Externalizable {
        private static final long serialVersionUID = -1579157666784550069L;
        private String name;
        private Long capacityInKB;

        public OSDriveDetails() {
        }

        public OSDriveDetails(String name, long capacityInKB) {
            this.name = name;
            this.capacityInKB = capacityInKB;
        }

        public Long getCapacityInBytes() {
            return this.capacityInKB * 1024L;
        }

        public Long getCapacityInKB() {
            return this.capacityInKB;
        }

        public Long getCapacityInMB() {
            return this.capacityInKB / 1024L;
        }

        public Long getCapacityInGB() {
            return this.getCapacityInMB() / 1024L;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeLong(this.capacityInKB);
            out.writeUTF(this.name);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.capacityInKB = in.readLong();
            this.name = in.readUTF();
        }
    }

    public static class OSNetInterfaceDetails
    implements Externalizable {
        private static final long serialVersionUID = 6720043955636646719L;
        private String address;
        private String name;
        private String description;

        public OSNetInterfaceDetails() {
        }

        public OSNetInterfaceDetails(String addr, String name, String description) {
            this.address = addr;
            this.name = name;
            this.description = description;
        }

        public String getAddress() {
            return this.address;
        }

        public String getName() {
            return this.name;
        }

        public String getDescription() {
            return this.description;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.address);
            out.writeUTF(this.name);
            out.writeUTF(this.description);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.address = in.readUTF();
            this.name = in.readUTF();
            this.description = in.readUTF();
        }
    }
}

