/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.os;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSDetailsProbe;
import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.internal.os.OSStatisticsProbe;
import com.gigaspaces.internal.os.OshiOSDetailsProbe;
import com.gigaspaces.internal.os.OshiOSStatisticsProbe;
import com.gigaspaces.internal.os.jmx.JMXOSDetailsProbe;
import com.gigaspaces.internal.os.jmx.JMXOSStatisticsProbe;
import com.gigaspaces.internal.os.sigar.SigarOSDetailsProbe;
import com.gigaspaces.internal.os.sigar.SigarOSStatisticsProbe;
import com.gigaspaces.internal.oshi.OshiChecker;
import com.gigaspaces.internal.sigar.SigarChecker;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class OSHelper {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.os");
    private static final OSStatisticsProbe statisticsProbe;
    private static final OSDetailsProbe detailsProbe;
    private static final OSStatistics NA_STATISTICS;
    private static final OSDetails NA_DETAILS;
    private static OSDetails details;

    public static OSDetails getDetails() {
        if (detailsProbe == null) {
            return NA_DETAILS;
        }
        try {
            if (details != null) {
                return details;
            }
            details = detailsProbe.probeDetails();
            return details;
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Failed to get configuration", e);
            e.printStackTrace();
            return NA_DETAILS;
        }
    }

    public static OSStatistics getStatistics() {
        if (statisticsProbe == null) {
            return NA_STATISTICS;
        }
        try {
            return statisticsProbe.probeStatistics();
        }
        catch (Exception e) {
            _logger.log(Level.FINE, "Failed to get stats", e);
            return NA_STATISTICS;
        }
    }

    static {
        NA_STATISTICS = new OSStatistics();
        NA_DETAILS = new OSDetails();
        OSStatisticsProbe statisticsProbeX = null;
        String statisticsProbeClass = System.getProperty("gs.admin.os.probe.statistics");
        if (statisticsProbeClass == null) {
            if (OshiChecker.isAvailable()) {
                statisticsProbeX = new OshiOSStatisticsProbe();
            } else if (SigarChecker.isAvailable()) {
                try {
                    statisticsProbeX = new SigarOSStatisticsProbe();
                    statisticsProbeX.probeStatistics();
                }
                catch (Throwable t) {
                    statisticsProbeX = null;
                    _logger.log(Level.FINE, "Trying to load sigar failed", t);
                }
            }
            if (statisticsProbeX == null) {
                try {
                    statisticsProbeX = new JMXOSStatisticsProbe();
                    statisticsProbeX.probeStatistics();
                }
                catch (Throwable t) {
                    statisticsProbeX = null;
                    _logger.log(Level.FINE, "Trying to load JMX failed", t);
                }
            }
        } else {
            try {
                statisticsProbeX = (OSStatisticsProbe)OSHelper.class.getClassLoader().loadClass(statisticsProbeClass).newInstance();
            }
            catch (Exception e) {
                statisticsProbeX = null;
            }
        }
        statisticsProbe = statisticsProbeX;
        OSDetailsProbe detailsProbeX = null;
        String detailsProbeClass = System.getProperty("gs.admin.os.probe.details");
        if (detailsProbeClass == null) {
            if (OshiChecker.isAvailable()) {
                detailsProbeX = new OshiOSDetailsProbe();
            } else if (SigarChecker.isAvailable()) {
                try {
                    detailsProbeX = new SigarOSDetailsProbe();
                    detailsProbeX.probeDetails();
                }
                catch (Throwable t) {
                    detailsProbeX = null;
                    _logger.log(Level.FINE, "Trying to load sigar failed", t);
                }
            }
            if (detailsProbeX == null) {
                try {
                    detailsProbeX = new JMXOSDetailsProbe();
                    detailsProbeX.probeDetails();
                }
                catch (Throwable t) {
                    detailsProbeX = null;
                    _logger.log(Level.FINE, "Trying to load JMX failed", t);
                }
            }
        } else {
            try {
                detailsProbeX = (OSDetailsProbe)OSHelper.class.getClassLoader().loadClass(detailsProbeClass).newInstance();
            }
            catch (Exception e) {
                detailsProbeX = null;
            }
        }
        detailsProbe = detailsProbeX;
    }
}

