/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.os;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

@InternalApi
public class OSStatistics
implements Externalizable {
    private static final long serialVersionUID = -6526052574312023489L;
    private long timestamp = -1L;
    private long freeSwapSpaceSize = -1L;
    private long freePhysicalMemorySize = -1L;
    private long actualFreePhysicalMemorySize = -1L;
    private double cpuPerc = -1.0;
    private long actualMemoryUsed;
    private double usedMemoryPerc;
    private OSNetInterfaceStats[] netStats;

    public OSStatistics() {
    }

    public OSStatistics(long timestamp, long freeSwapSpaceSize, long freePhysicalMemorySize) {
        this(timestamp, freeSwapSpaceSize, freePhysicalMemorySize, -1L, -1.0, -1L, -1.0, null);
    }

    public OSStatistics(long timestamp, long freeSwapSpaceSize, long freePhysicalMemorySize, long actualFreePhysicalMemorySize, double cpuPerc, long actualMemoryUsed, double usedMemoryPerc, OSNetInterfaceStats[] netStats) {
        this.timestamp = timestamp;
        this.freeSwapSpaceSize = freeSwapSpaceSize;
        this.freePhysicalMemorySize = freePhysicalMemorySize;
        this.actualFreePhysicalMemorySize = actualFreePhysicalMemorySize;
        this.cpuPerc = cpuPerc;
        this.netStats = netStats;
        this.usedMemoryPerc = usedMemoryPerc;
        this.actualMemoryUsed = actualMemoryUsed;
    }

    public long getActualMemoryUsed() {
        return this.actualMemoryUsed;
    }

    public double getUsedMemoryPerc() {
        return this.usedMemoryPerc;
    }

    public boolean isNA() {
        return this.timestamp == -1L;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public long getFreeSwapSpaceSize() {
        return this.freeSwapSpaceSize;
    }

    public long getFreePhysicalMemorySize() {
        return this.freePhysicalMemorySize;
    }

    public long getActualFreePhysicalMemorySize() {
        return this.actualFreePhysicalMemorySize;
    }

    public double getCpuPerc() {
        return this.cpuPerc;
    }

    public OSNetInterfaceStats[] getNetStats() {
        return this.netStats;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong(this.timestamp);
        out.writeLong(this.freeSwapSpaceSize);
        out.writeLong(this.freePhysicalMemorySize);
        out.writeLong(this.actualFreePhysicalMemorySize);
        out.writeDouble(this.cpuPerc);
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v10_1_0)) {
            out.writeDouble(this.usedMemoryPerc);
            out.writeLong(this.actualMemoryUsed);
        }
        if (this.netStats == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeInt(this.netStats.length);
            for (OSNetInterfaceStats netStat : this.netStats) {
                netStat.writeExternal(out);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size;
        this.timestamp = in.readLong();
        this.freeSwapSpaceSize = in.readLong();
        this.freePhysicalMemorySize = in.readLong();
        this.actualFreePhysicalMemorySize = in.readLong();
        this.cpuPerc = in.readDouble();
        if (LRMIInvocationContext.getEndpointLogicalVersion().greaterOrEquals(PlatformLogicalVersion.v10_1_0)) {
            this.usedMemoryPerc = in.readDouble();
            this.actualMemoryUsed = in.readLong();
        }
        if (in.readBoolean() && 0 < (size = in.readInt())) {
            this.netStats = new OSNetInterfaceStats[size];
            for (int i = 0; i < this.netStats.length; ++i) {
                this.netStats[i] = new OSNetInterfaceStats();
                this.netStats[i].readExternal(in);
            }
        }
    }

    public static class OSNetInterfaceStats
    implements Externalizable {
        private static final long serialVersionUID = 2554963851193006126L;
        private String name;
        private long rxBytes;
        private long txBytes;
        private long rxPackets;
        private long txPackets;
        private long rxErrors;
        private long txErrors;
        private long rxDropped;
        private long txDropped;

        public OSNetInterfaceStats() {
        }

        public OSNetInterfaceStats(String name, long rxBytes, long txBytes, long rxPackets, long txPackets, long rxErrors, long txErrors, long rxDropped, long txDropped) {
            this.name = name;
            this.rxBytes = rxBytes;
            this.txBytes = txBytes;
            this.rxPackets = rxPackets;
            this.txPackets = txPackets;
            this.rxErrors = rxErrors;
            this.txErrors = txErrors;
            this.rxDropped = rxDropped;
            this.txDropped = txDropped;
        }

        public String getName() {
            return this.name;
        }

        public long getRxBytes() {
            return this.rxBytes;
        }

        public long getTxBytes() {
            return this.txBytes;
        }

        public long getRxPackets() {
            return this.rxPackets;
        }

        public long getTxPackets() {
            return this.txPackets;
        }

        public long getRxErrors() {
            return this.rxErrors;
        }

        public long getTxErrors() {
            return this.txErrors;
        }

        @Deprecated
        public long getRxDropped() {
            return this.rxDropped;
        }

        @Deprecated
        public long getTxDropped() {
            return this.txDropped;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeUTF(this.name);
            out.writeLong(this.rxBytes);
            out.writeLong(this.txBytes);
            out.writeLong(this.rxPackets);
            out.writeLong(this.txPackets);
            out.writeLong(this.rxErrors);
            out.writeLong(this.txErrors);
            out.writeLong(this.rxDropped);
            out.writeLong(this.txDropped);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.name = in.readUTF();
            this.rxBytes = in.readLong();
            this.txBytes = in.readLong();
            this.rxPackets = in.readLong();
            this.txPackets = in.readLong();
            this.rxErrors = in.readLong();
            this.txErrors = in.readLong();
            this.rxDropped = in.readLong();
            this.txDropped = in.readLong();
        }
    }
}

