/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.os;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSDetailsProbe;
import com.gigaspaces.internal.oshi.OshiChecker;
import com.gigaspaces.start.SystemInfo;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import oshi.hardware.GlobalMemory;
import oshi.hardware.HardwareAbstractionLayer;
import oshi.hardware.NetworkIF;
import oshi.software.os.OSFileStore;
import oshi.software.os.OperatingSystem;
import oshi.util.FormatUtil;
import oshi.util.ParseUtil;

@InternalApi
public class OshiOSDetailsProbe
implements OSDetailsProbe {
    private static final String uid = SystemInfo.singleton().network().getHost().getHostAddress();
    private static final String localHostAddress = SystemInfo.singleton().network().getHost().getHostAddress();
    private static final String localHostName = SystemInfo.singleton().network().getHost().getHostName();
    private static final oshi.SystemInfo oshiSystemInfo = OshiChecker.getSystemInfo();

    @Override
    public OSDetails probeDetails() throws Exception {
        if (uid == null) {
            return new OSDetails();
        }
        OperatingSystem operatingSystem = oshiSystemInfo.getOperatingSystem();
        HardwareAbstractionLayer hardwareAbstractionLayer = oshiSystemInfo.getHardware();
        GlobalMemory memory = hardwareAbstractionLayer.getMemory();
        return new OSDetails(uid, operatingSystem.getManufacturer(), FormatUtil.formatBytes((long)operatingSystem.getBitness()), operatingSystem.getVersion().getBuildNumber(), hardwareAbstractionLayer.getProcessor().getLogicalProcessorCount(), memory.getSwapTotal(), memory.getTotal(), localHostName, localHostAddress, this.getOSNetDetails(), this.getOSDriveDetailsArray(), this.getVendorDetails());
    }

    private OSDetails.OSNetInterfaceDetails[] getOSNetInterfacesDetailsArray() throws SocketException {
        NetworkIF[] networkIFs = oshiSystemInfo.getHardware().getNetworkIFs();
        OSDetails.OSNetInterfaceDetails[] netInterfaceConfigArray = new OSDetails.OSNetInterfaceDetails[networkIFs.length];
        for (int index = 0; index < networkIFs.length; ++index) {
            OSDetails.OSNetInterfaceDetails netInterfaceConfig;
            NetworkIF networkIF = networkIFs[index];
            NetworkInterface netInterface = networkIF.getNetworkInterface();
            String addr = ParseUtil.byteArrayToHexString((byte[])netInterface.getHardwareAddress());
            String name = netInterface.getName();
            String description = netInterface.getDisplayName();
            if (description == null) {
                description = String.valueOf(name);
            }
            netInterfaceConfigArray[index] = netInterfaceConfig = new OSDetails.OSNetInterfaceDetails(addr, name, description);
        }
        return netInterfaceConfigArray;
    }

    private OSDetails.OSNetInterfaceDetails[] getOSNetDetails() throws SocketException {
        NetworkIF[] networkIFs = oshiSystemInfo.getHardware().getNetworkIFs();
        OSDetails.OSNetInterfaceDetails[] interfacesList = new OSDetails.OSNetInterfaceDetails[networkIFs.length];
        for (int i = 0; i < networkIFs.length; ++i) {
            OSDetails.OSNetInterfaceDetails osNetInterfaceDetails;
            NetworkInterface networkInterface = networkIFs[i].getNetworkInterface();
            byte[] hwAddress = networkInterface.getHardwareAddress();
            String hardwareAddressStr = this.translateByteArrayToHwAddress(hwAddress);
            String name = networkInterface.getName();
            String displayName = networkInterface.getDisplayName();
            interfacesList[i] = osNetInterfaceDetails = new OSDetails.OSNetInterfaceDetails(hardwareAddressStr, name, displayName);
        }
        return interfacesList;
    }

    private OSDetails.OSDriveDetails[] getOSDriveDetailsArray() {
        ArrayList<OSDetails.OSDriveDetails> drives = new ArrayList<OSDetails.OSDriveDetails>();
        OperatingSystem operatingSystem = oshiSystemInfo.getOperatingSystem();
        for (OSFileStore drive : operatingSystem.getFileSystem().getFileStores()) {
            if (!drive.getDescription().equals("Local Disk") && !drive.getDescription().equals("Network Drive")) continue;
            drives.add(new OSDetails.OSDriveDetails(drive.getName(), drive.getTotalSpace() / 1024L));
        }
        return drives.toArray(new OSDetails.OSDriveDetails[drives.size()]);
    }

    private OSDetails.OSVendorDetails getVendorDetails() {
        return new OSDetails.OSVendorDetails(oshiSystemInfo.getOperatingSystem().getFamily(), oshiSystemInfo.getOperatingSystem().getVersion().getCodeName(), oshiSystemInfo.getOperatingSystem().getManufacturer(), oshiSystemInfo.getOperatingSystem().getVersion().getVersion());
    }

    private String translateByteArrayToHwAddress(byte[] hardwareAddress) {
        String hardwareAddressStr = "";
        for (int index = 0; index < hardwareAddress.length; ++index) {
            String hexStr;
            int val = hardwareAddress[index];
            if (val < 0) {
                val = 256 + val;
            }
            if ((hexStr = Integer.toString(val, 16).toUpperCase()).length() == 1) {
                hexStr = 0 + hexStr;
            }
            hardwareAddressStr = hardwareAddressStr + hexStr;
            if (index >= hardwareAddress.length - 1) continue;
            hardwareAddressStr = hardwareAddressStr + ":";
        }
        return hardwareAddressStr;
    }
}

