/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.os;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.BootIOUtils;
import com.gigaspaces.internal.os.ProcessKiller;
import com.gigaspaces.internal.os.ProcessUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

@InternalApi
public class ProcessHandleProcessKiller
implements ProcessKiller {
    private final Class processHandleClass = Class.forName("java.lang.ProcessHandle");
    private final Method ofMethod = this.processHandleClass.getMethod("of", Long.TYPE);
    private final Method descendantsMethod = this.processHandleClass.getMethod("descendants", new Class[0]);
    private final Method destroyMethod = this.processHandleClass.getMethod("destroy", new Class[0]);
    private final Method destroyForciblyMethod = this.processHandleClass.getMethod("destroyForcibly", new Class[0]);
    private final Method isAliveMethod = this.processHandleClass.getMethod("isAlive", new Class[0]);

    @Override
    public String getName() {
        return "ProcessHandle";
    }

    @Override
    public boolean kill(long pid, long timeout, boolean recursive) {
        try {
            Optional processHandle = (Optional)this.ofMethod.invoke(null, pid);
            if (!processHandle.isPresent()) {
                return true;
            }
            ArrayList<Object> processes = new ArrayList<Object>();
            processes.add(processHandle.get());
            if (recursive) {
                Stream descendants = (Stream)this.descendantsMethod.invoke(processHandle.get(), new Object[0]);
                processes.addAll(descendants.collect(Collectors.toList()));
            }
            for (Object e : processes) {
                this.destroyMethod.invoke(e, new Object[0]);
            }
            try {
                BootIOUtils.waitFor(() -> this.pruneTerminated(processes), timeout, 100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
            for (Object e : processes) {
                this.destroyForciblyMethod.invoke(e, new Object[0]);
            }
            return this.pruneTerminated(processes);
        }
        catch (ReflectiveOperationException e) {
            ProcessUtils.logger.warning("Failed to kill process " + pid + ": " + e.getMessage());
            return false;
        }
    }

    private boolean pruneTerminated(Collection<Object> processes) {
        processes.removeIf(proc -> !this.isAlive(proc));
        return processes.isEmpty();
    }

    private boolean isAlive(Object proc) {
        try {
            return (Boolean)this.isAliveMethod.invoke(proc, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            throw new IllegalStateException("Failed to check if process is alive", e);
        }
    }
}

