/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.os;

import com.gigaspaces.internal.jvm.JavaUtils;
import com.gigaspaces.internal.os.ProcessHandleProcessKiller;
import com.gigaspaces.internal.os.ProcessKiller;
import com.gigaspaces.internal.sigar.SigarChecker;
import java.util.Optional;
import java.util.logging.Logger;

public class ProcessUtils {
    public static final Logger logger = Logger.getLogger(ProcessUtils.class.getName());
    private static final Optional<ProcessKiller> processKiller = ProcessUtils.initProcessKiller();
    private static final boolean RECURSIVE_DEFAULT = ProcessUtils.initDefaultRecursive();

    private static boolean initDefaultRecursive() {
        String recursive = System.getProperty("com.gs.process.kill-recursive", "");
        if (recursive.isEmpty()) {
            return JavaUtils.isWindows();
        }
        return Boolean.parseBoolean(recursive);
    }

    private static Optional<ProcessKiller> initProcessKiller() {
        if (JavaUtils.greaterOrEquals(9)) {
            try {
                return Optional.of(new ProcessHandleProcessKiller());
            }
            catch (ReflectiveOperationException e) {
                logger.warning("Failed to create ProcessHandleProcessKiller: " + e.getMessage());
            }
        }
        if (SigarChecker.isAvailable()) {
            return Optional.of(SigarChecker.createProcessKiller());
        }
        return Optional.empty();
    }

    public static Optional<String> getProcessKillerName() {
        return processKiller.map(ProcessKiller::getName);
    }

    public static boolean kill(long pid, long timeout) {
        return ProcessUtils.kill(pid, timeout, RECURSIVE_DEFAULT);
    }

    public static boolean kill(long pid, long timeout, boolean recursive) {
        return processKiller.map(k -> k.kill(pid, timeout, recursive)).orElse(false);
    }
}

