/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.os.jmx;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSDetailsProbe;
import com.gigaspaces.start.SystemInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Enumeration;

@InternalApi
public class JMXOSDetailsProbe
implements OSDetailsProbe {
    private static final String uid = SystemInfo.singleton().network().getHost().getHostAddress();
    private static final String localHostAddress = SystemInfo.singleton().network().getHost().getHostAddress();
    private static final String localHostName = SystemInfo.singleton().network().getHost().getHostName();
    private static final OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
    private static Method getTotalSwapSpaceSize;
    private static Method getTotalPhysicalMemorySize;

    @Override
    public OSDetails probeDetails() {
        if (uid == null) {
            return new OSDetails();
        }
        long totalSwapSpaceSize = -1L;
        if (getTotalSwapSpaceSize != null) {
            try {
                totalSwapSpaceSize = (Long)getTotalSwapSpaceSize.invoke((Object)operatingSystemMXBean, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        long totalPhysicalMemorySize = -1L;
        if (getTotalPhysicalMemorySize != null) {
            try {
                totalPhysicalMemorySize = (Long)getTotalPhysicalMemorySize.invoke((Object)operatingSystemMXBean, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        OSDetails.OSNetInterfaceDetails[] osNetInterfaceDetailsArray = this.retrieveOSNetInterfaceDetails();
        return new OSDetails(uid, operatingSystemMXBean.getName(), operatingSystemMXBean.getArch(), operatingSystemMXBean.getVersion(), operatingSystemMXBean.getAvailableProcessors(), totalSwapSpaceSize, totalPhysicalMemorySize, localHostName, localHostAddress, osNetInterfaceDetailsArray, null, null);
    }

    private OSDetails.OSNetInterfaceDetails[] retrieveOSNetInterfaceDetails() {
        OSDetails.OSNetInterfaceDetails[] osNetInterfaceDetailsArray = null;
        try {
            Class<?> networkInterfaceClass = Class.forName("java.net.NetworkInterface");
            Method method = networkInterfaceClass.getMethod("getHardwareAddress", new Class[0]);
            Enumeration<NetworkInterface> networkInterfacesEnum = NetworkInterface.getNetworkInterfaces();
            ArrayList<OSDetails.OSNetInterfaceDetails> interfacesList = new ArrayList<OSDetails.OSNetInterfaceDetails>();
            while (networkInterfacesEnum.hasMoreElements()) {
                NetworkInterface networkInterface = networkInterfacesEnum.nextElement();
                byte[] hardwareAddress = (byte[])method.invoke((Object)networkInterface, new Object[0]);
                if (hardwareAddress == null) continue;
                String hardwareAddressStr = "";
                for (int index = 0; index < hardwareAddress.length; ++index) {
                    String hexStr;
                    int val = hardwareAddress[index];
                    if (val < 0) {
                        val = 256 + val;
                    }
                    if ((hexStr = Integer.toString(val, 16).toUpperCase()).length() == 1) {
                        hexStr = 0 + hexStr;
                    }
                    hardwareAddressStr = hardwareAddressStr + hexStr;
                    if (index >= hardwareAddress.length - 1) continue;
                    hardwareAddressStr = hardwareAddressStr + ":";
                }
                String name = networkInterface.getName();
                String displayName = networkInterface.getDisplayName();
                OSDetails.OSNetInterfaceDetails osNetInterfaceDetails = new OSDetails.OSNetInterfaceDetails(hardwareAddressStr, name, displayName);
                interfacesList.add(osNetInterfaceDetails);
            }
            osNetInterfaceDetailsArray = interfacesList.toArray(new OSDetails.OSNetInterfaceDetails[0]);
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return osNetInterfaceDetailsArray;
    }

    static {
        try {
            Method method2;
            Class<?> sunOperatingSystemMXBeanClass = JMXOSDetailsProbe.class.getClassLoader().loadClass("com.sun.management.OperatingSystemMXBean");
            try {
                method2 = sunOperatingSystemMXBeanClass.getMethod("getTotalSwapSpaceSize", new Class[0]);
                method2.setAccessible(true);
                getTotalSwapSpaceSize = method2;
            }
            catch (NoSuchMethodException method2) {
                // empty catch block
            }
            try {
                method2 = sunOperatingSystemMXBeanClass.getMethod("getTotalPhysicalMemorySize", new Class[0]);
                method2.setAccessible(true);
                getTotalPhysicalMemorySize = method2;
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

