/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.os.jmx;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.internal.os.OSStatisticsProbe;
import com.gigaspaces.internal.os.jmx.JMXOSDetailsProbe;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;

@InternalApi
public class JMXOSStatisticsProbe
implements OSStatisticsProbe {
    private static final OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
    private static Method getCommittedVirtualMemorySize;
    private static Method getFreeSwapSpaceSize;
    private static Method getFreePhysicalMemorySize;

    @Override
    public OSStatistics probeStatistics() {
        long committedVirtualMemorySize = -1L;
        if (getCommittedVirtualMemorySize != null) {
            try {
                committedVirtualMemorySize = (Long)getCommittedVirtualMemorySize.invoke((Object)operatingSystemMXBean, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        long freeSwapSpaceSize = -1L;
        if (getFreeSwapSpaceSize != null) {
            try {
                freeSwapSpaceSize = (Long)getFreeSwapSpaceSize.invoke((Object)operatingSystemMXBean, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        long freePhysicalMemorySize = -1L;
        if (getFreePhysicalMemorySize != null) {
            try {
                freePhysicalMemorySize = (Long)getFreePhysicalMemorySize.invoke((Object)operatingSystemMXBean, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new OSStatistics(System.currentTimeMillis(), freeSwapSpaceSize, freePhysicalMemorySize);
    }

    static {
        try {
            Method method2;
            Class<?> sunOperatingSystemMXBeanClass = JMXOSDetailsProbe.class.getClassLoader().loadClass("com.sun.management.OperatingSystemMXBean");
            try {
                method2 = sunOperatingSystemMXBeanClass.getMethod("getCommittedVirtualMemorySize", new Class[0]);
                method2.setAccessible(true);
                getCommittedVirtualMemorySize = method2;
            }
            catch (NoSuchMethodException method2) {
                // empty catch block
            }
            try {
                method2 = sunOperatingSystemMXBeanClass.getMethod("getFreeSwapSpaceSize", new Class[0]);
                method2.setAccessible(true);
                getFreeSwapSpaceSize = method2;
            }
            catch (NoSuchMethodException method3) {
                // empty catch block
            }
            try {
                method2 = sunOperatingSystemMXBeanClass.getMethod("getFreePhysicalMemorySize", new Class[0]);
                method2.setAccessible(true);
                getFreePhysicalMemorySize = method2;
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

