/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.os.sigar;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.os.OSDetails;
import com.gigaspaces.internal.os.OSDetailsProbe;
import com.gigaspaces.internal.sigar.SigarHolder;
import com.gigaspaces.start.SystemInfo;
import java.util.ArrayList;
import org.hyperic.sigar.CpuInfo;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.OperatingSystem;
import org.hyperic.sigar.Sigar;

@InternalApi
public class SigarOSDetailsProbe
implements OSDetailsProbe {
    private static final String uid = SystemInfo.singleton().network().getHost().getHostAddress();
    private static final String localHostAddress = SystemInfo.singleton().network().getHost().getHostAddress();
    private static final String localHostName = SystemInfo.singleton().network().getHost().getHostName();
    private final Sigar sigar = SigarHolder.getSigar();

    @Override
    public OSDetails probeDetails() throws Exception {
        OperatingSystem sys = OperatingSystem.getInstance();
        CpuInfo[] infos = this.sigar.getCpuInfoList();
        String[] netInterfaceList = this.sigar.getNetInterfaceList();
        OSDetails.OSNetInterfaceDetails[] netInterfaceConfigArray = new OSDetails.OSNetInterfaceDetails[netInterfaceList.length];
        for (int index = 0; index < netInterfaceList.length; ++index) {
            OSDetails.OSNetInterfaceDetails netInterfaceConfig;
            String interfaceName = netInterfaceList[index];
            NetInterfaceConfig config = this.sigar.getNetInterfaceConfig(interfaceName);
            String addr = config.getHwaddr();
            String name = config.getName();
            String description = config.getDescription();
            if (description == null) {
                description = "";
            }
            netInterfaceConfigArray[index] = netInterfaceConfig = new OSDetails.OSNetInterfaceDetails(addr, name, description);
        }
        ArrayList<OSDetails.OSDriveDetails> drives = new ArrayList<OSDetails.OSDriveDetails>();
        for (FileSystem drive : this.sigar.getFileSystemList()) {
            if (drive.getType() != 2 && drive.getType() != 3) continue;
            String dirName = drive.getDirName();
            FileSystemUsage fileSystemUsage = this.sigar.getFileSystemUsage(dirName);
            long capacityInKB = fileSystemUsage.getTotal();
            drives.add(new OSDetails.OSDriveDetails(dirName, capacityInKB));
        }
        return new OSDetails(uid, sys.getName(), sys.getArch(), sys.getVersion(), infos[0].getTotalCores(), this.sigar.getSwap().getTotal(), this.sigar.getMem().getTotal(), localHostName, localHostAddress, netInterfaceConfigArray, drives.toArray(new OSDetails.OSDriveDetails[drives.size()]), new OSDetails.OSVendorDetails(sys.getVendor(), sys.getVendorCodeName(), sys.getVendorName(), sys.getVendorVersion()));
    }
}

