/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.os.sigar;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.internal.os.OSStatisticsProbe;
import com.gigaspaces.internal.sigar.SigarHolder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.Mem;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.Swap;

@InternalApi
public class SigarOSStatisticsProbe
implements OSStatisticsProbe {
    private Sigar sigar;
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.os.statistics");
    private static final boolean _isWindows = System.getProperty("os.name").toLowerCase().startsWith("win");
    private Map<String, Integer> failedInterfacesCount = new HashMap<String, Integer>();

    public SigarOSStatisticsProbe() {
        this.sigar = SigarHolder.getSigar();
    }

    @Override
    public synchronized OSStatistics probeStatistics() throws Exception {
        long actualUsedMemory;
        double memoryUsedPerc;
        String[] ifs = this.sigar.getNetInterfaceList();
        ArrayList<OSStatistics.OSNetInterfaceStats> netStats = new ArrayList<OSStatistics.OSNetInterfaceStats>();
        for (String anIf : ifs) {
            Integer failureCount = this.failedInterfacesCount.get(anIf);
            if (failureCount != null && failureCount >= 3) continue;
            try {
                NetInterfaceStat stat = this.sigar.getNetInterfaceStat(anIf);
                netStats.add(new OSStatistics.OSNetInterfaceStats(anIf, stat.getRxBytes(), stat.getTxBytes(), stat.getRxPackets(), stat.getTxPackets(), stat.getRxErrors(), stat.getTxErrors(), stat.getRxDropped(), stat.getTxDropped()));
            }
            catch (SigarException e) {
                failureCount = failureCount == null ? Integer.valueOf(1) : Integer.valueOf(failureCount + 1);
                this.failedInterfacesCount.put(anIf, failureCount);
            }
        }
        Swap swap = this.sigar.getSwap();
        Mem mem = this.sigar.getMem();
        CpuPerc cpuPerc = this.sigar.getCpuPerc();
        double memoryUsedPercFromSigar = mem.getUsedPercent();
        long actualUsedMemoryFromSigar = mem.getActualUsed();
        long totalPhysicalMemorySizeInBytes = mem.getTotal();
        long freePhysicalMemorySizeInBytes = mem.getFree();
        double memoryUsedPercCalculated = SigarOSStatisticsProbe.computePerc(totalPhysicalMemorySizeInBytes - freePhysicalMemorySizeInBytes, totalPhysicalMemorySizeInBytes);
        long actualUsedMemoryCalculated = totalPhysicalMemorySizeInBytes - freePhysicalMemorySizeInBytes;
        if (_isWindows) {
            memoryUsedPerc = memoryUsedPercCalculated;
            actualUsedMemory = actualUsedMemoryCalculated;
        } else {
            memoryUsedPerc = memoryUsedPercFromSigar;
            actualUsedMemory = actualUsedMemoryFromSigar;
        }
        if (_logger.isLoggable(Level.FINER)) {
            _logger.log(Level.FINER, "Memory probe, is winOS:" + _isWindows + ", mem used:" + mem.getUsed() + ", memoryUsedPercSigar:" + memoryUsedPercFromSigar + ", memoryUsedPercCalculated:" + memoryUsedPercCalculated + ", mem actual Used from Sigar:" + actualUsedMemoryFromSigar + ", mem actual Calculated:" + actualUsedMemoryCalculated + ", mem free:" + mem.getFree() + ", mem ram:" + mem.getRam() + ", mem actual free:" + mem.getActualFree());
            _logger.log(Level.FINER, "Memory probe (GB):, mem actual Used from Sigar:" + (double)actualUsedMemoryFromSigar / 1024.0 / 1024.0 / 1024.0 + ", mem actual Calculated:" + (double)actualUsedMemoryCalculated / 1024.0 / 1024.0 / 1024.0 + ", mem free GB:" + (double)mem.getFree() / 1024.0 / 1024.0 / 1024.0);
            _logger.log(Level.FINER, "Memory probe, swap used:" + swap.getUsed() + ", swap free:" + swap.getFree() + ", cpu perc getCombined:" + cpuPerc.getCombined());
        }
        return new OSStatistics(System.currentTimeMillis(), swap.getFree(), mem.getFree(), mem.getActualFree(), cpuPerc.getCombined(), actualUsedMemory, memoryUsedPerc, netStats.toArray(new OSStatistics.OSNetInterfaceStats[netStats.size()]));
    }

    public static double computePerc(long value, long max) {
        return (double)value / (double)max * 100.0;
    }
}

