/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.oshi;

import com.gigaspaces.internal.os.OSStatistics;
import com.gigaspaces.internal.oshi.OshiChecker;
import java.net.NetworkInterface;
import oshi.SystemInfo;
import oshi.hardware.GlobalMemory;
import oshi.hardware.NetworkIF;

public class OshiUtils {
    public static SystemInfo oshiSystemInfo = OshiChecker.getSystemInfo();
    public static final GlobalMemory memory = oshiSystemInfo.getHardware().getMemory();

    public static double getUsedMemoryPerc(GlobalMemory memory) {
        long usedMemory = OshiUtils.getActualUsedMemory(memory);
        return (double)usedMemory / (double)memory.getTotal() * 100.0;
    }

    public static long getActualUsedMemory(GlobalMemory memory) {
        return memory.getTotal() - memory.getAvailable();
    }

    public static long calcFreeSwapMemory(GlobalMemory memory) {
        return memory.getSwapTotal() - memory.getSwapUsed();
    }

    public static OSStatistics.OSNetInterfaceStats[] calcNetStats() {
        NetworkIF[] networkIFs = oshiSystemInfo.getHardware().getNetworkIFs();
        OSStatistics.OSNetInterfaceStats[] netInterfaceConfigArray = new OSStatistics.OSNetInterfaceStats[networkIFs.length];
        for (int index = 0; index < networkIFs.length; ++index) {
            OSStatistics.OSNetInterfaceStats netInterfaceStats;
            NetworkIF networkIF = networkIFs[index];
            NetworkInterface netInterface = networkIF.getNetworkInterface();
            netInterfaceConfigArray[index] = netInterfaceStats = new OSStatistics.OSNetInterfaceStats(networkIF.getName(), networkIF.getBytesRecv(), networkIF.getBytesSent(), networkIF.getPacketsRecv(), networkIF.getPacketsSent(), networkIF.getInErrors(), networkIF.getOutErrors(), -1L, -1L);
        }
        return netInterfaceConfigArray;
    }
}

