/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.services;

import com.gigaspaces.classloader.CustomURLClassLoader;
import com.gigaspaces.start.ClasspathBuilder;
import java.io.Closeable;

public abstract class ServiceFactory {
    public Closeable createService() {
        String serviceClassName = this.getServiceClassName();
        ClasspathBuilder classpathBuilder = new ClasspathBuilder();
        this.initializeClasspath(classpathBuilder);
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            CustomURLClassLoader classLoader = new CustomURLClassLoader(this.getServiceName(), classpathBuilder.toURLsArray(), origClassLoader);
            Thread.currentThread().setContextClassLoader(classLoader);
            Class<?> serviceClass = classLoader.loadClass(serviceClassName);
            Object service = serviceClass.newInstance();
            Closeable closeable = (Closeable)service;
            return closeable;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create an instance of " + serviceClassName, e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    public abstract String getServiceName();

    protected abstract String getServiceClassName();

    protected abstract void initializeClasspath(ClasspathBuilder var1);
}

