/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.sigar;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.jvm.JavaUtils;
import com.gigaspaces.internal.os.ProcessKiller;
import com.gigaspaces.internal.sigar.SigarHolder;

@InternalApi
public class SigarChecker {
    private static final boolean enabled = SigarChecker.initEnabled();

    private static boolean initEnabled() {
        String enabled = System.getProperty("com.gs.sigar.enabled", "");
        if (enabled.isEmpty()) {
            return !JavaUtils.isWindows() || !JavaUtils.greaterOrEquals(9);
        }
        return Boolean.parseBoolean(enabled);
    }

    public static boolean isAvailable() {
        try {
            return enabled && SigarHolder.getSigar() != null;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static ProcessKiller createProcessKiller() {
        return new ProcessKiller(){

            @Override
            public String getName() {
                return "Sigar";
            }

            @Override
            public boolean kill(long pid, long timeout, boolean recursive) {
                try {
                    return SigarHolder.singleton().kill(pid, timeout, recursive);
                }
                catch (Throwable e) {
                    throw new RuntimeException("Failed to kill process " + pid + ": " + e.getMessage(), e);
                }
            }
        };
    }
}

