/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.sigar;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.BootIOUtils;
import com.gigaspaces.internal.jvm.JavaUtils;
import com.gigaspaces.start.SystemBoot;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.hyperic.sigar.ProcState;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;

@InternalApi
public class SigarHolder {
    private static SigarHolder singleton;
    private final Sigar sigar;

    public static synchronized SigarHolder singleton() {
        if (singleton == null) {
            Sigar sigar = new Sigar();
            singleton = sigar.getPid() != -1L ? new SigarHolder(sigar) : null;
        }
        return singleton;
    }

    public static Sigar getSigar() {
        return SigarHolder.singleton().sigar;
    }

    public static synchronized void release() {
        if (!SystemBoot.isRunningWithinGSC() && singleton != null) {
            SigarHolder.singleton.sigar.close();
            singleton = null;
        }
    }

    private SigarHolder(Sigar sigar) {
        this.sigar = sigar;
    }

    public boolean kill(long pid, long timeout, boolean recursive) throws SigarException {
        LinkedHashSet<Long> pids = new LinkedHashSet<Long>();
        pids.add(pid);
        if (recursive) {
            pids.addAll(this.getDescendants(pid));
        }
        if (this.killAll(pids, "SIGTERM")) {
            return true;
        }
        try {
            if (BootIOUtils.waitFor(() -> this.pruneTerminated(pids), timeout, 100L)) {
                return true;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return false;
        }
        if (JavaUtils.isWindows()) {
            return false;
        }
        return this.killAll(pids, "SIGKILL");
    }

    private boolean killAll(Set<Long> pids, String signal) throws SigarException {
        for (Long currPid : pids) {
            this.kill(currPid, signal);
        }
        return this.pruneTerminated(pids);
    }

    private Map<Long, ProcState> getAllProcesses() throws SigarException {
        HashMap<Long, ProcState> result = new HashMap<Long, ProcState>();
        for (long pid : this.sigar.getProcList()) {
            try {
                result.put(pid, this.sigar.getProcState(pid));
            }
            catch (SigarException sigarException) {
                // empty catch block
            }
        }
        return result;
    }

    private Set<Long> getDescendants(long ppid) throws SigarException {
        int sizeBefore;
        int sizeAfter;
        LinkedHashSet<Long> result = new LinkedHashSet<Long>();
        Map<Long, ProcState> processes = this.getAllProcesses();
        processes.remove(ppid);
        do {
            sizeBefore = result.size();
            Iterator<Map.Entry<Long, ProcState>> iterator = processes.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<Long, ProcState> entry = iterator.next();
                if (!result.contains(entry.getValue().getPpid())) continue;
                result.add(entry.getKey());
                iterator.remove();
            }
        } while ((sizeAfter = result.size()) != sizeBefore);
        return result;
    }

    private boolean pruneTerminated(Set<Long> pids) {
        pids.removeIf(pid -> !this.isAlive((long)pid));
        return pids.isEmpty();
    }

    private void kill(long pid, String signal) throws SigarException {
        block2: {
            try {
                this.sigar.kill(pid, signal);
            }
            catch (SigarException e) {
                if (!this.isAlive(pid)) break block2;
                throw e;
            }
        }
    }

    private boolean isAlive(long pid) {
        try {
            this.sigar.getProcTime(pid);
            return true;
        }
        catch (SigarException e) {
            return false;
        }
    }
}

