/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.utils.concurrent;

import com.gigaspaces.api.InternalApi;

@InternalApi
public class GSThread
extends Thread {
    private static final String PREFIX = "GS-";

    public GSThread(Runnable target) {
        super(target);
        this.setName(PREFIX + this.getName());
    }

    public GSThread(String name) {
        super(GSThread.appendPrefixIfNeeded(name));
    }

    public GSThread(Runnable target, String name) {
        super(target, GSThread.appendPrefixIfNeeded(name));
    }

    public GSThread(ThreadGroup group, Runnable target, String name) {
        super(group, target, GSThread.appendPrefixIfNeeded(name));
    }

    public GSThread(ThreadGroup group, Runnable target, String name, long stackSize) {
        super(group, target, GSThread.appendPrefixIfNeeded(name), stackSize);
    }

    private static String appendPrefixIfNeeded(String name) {
        return name.startsWith(PREFIX) ? name : PREFIX + name;
    }
}

