/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.version;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.version.PlatformVersion;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.UnmarshalException;

@InternalApi
public class PlatformLogicalVersion
implements Externalizable,
Comparable<PlatformLogicalVersion> {
    private static final long serialVersionUID = 1L;
    private static final byte SERIAL_VERSION = -127;
    private static final int LAST_BUILD_NUMBER = 30000;
    private static final PlatformLogicalVersion LOGICAL_VERSION = PlatformLogicalVersion.fromVersion(PlatformVersion.getInstance());
    private byte _majorVersion;
    private byte _minorVersion;
    private byte _servicePackVersion;
    private int _buildNumber;
    private int _subBuildNumber;
    public static final PlatformLogicalVersion v9_1_0 = PlatformLogicalVersion.fromBuild(9, 1, 0, 7500);
    public static final PlatformLogicalVersion v9_1_1 = PlatformLogicalVersion.fromBuild(9, 1, 1, 7700);
    public static final PlatformLogicalVersion v9_1_2 = PlatformLogicalVersion.fromBuild(9, 1, 2, 7920);
    public static final PlatformLogicalVersion v9_5_0 = PlatformLogicalVersion.fromBuild(9, 5, 0, 8500);
    public static final PlatformLogicalVersion v9_5_1 = PlatformLogicalVersion.fromBuild(9, 5, 1, 8700);
    public static final PlatformLogicalVersion v9_5_2 = PlatformLogicalVersion.fromBuild(9, 5, 2, 8900);
    public static final PlatformLogicalVersion v9_5_2_PATCH3 = PlatformLogicalVersion.fromBuild(9, 5, 2, 8933);
    public static final PlatformLogicalVersion v9_6_0 = PlatformLogicalVersion.fromBuild(9, 6, 0, 9500);
    public static final PlatformLogicalVersion v9_6_1 = PlatformLogicalVersion.fromBuild(9, 6, 1, 9700);
    public static final PlatformLogicalVersion v9_6_2_PATCH3 = PlatformLogicalVersion.fromBuild(9, 6, 2, 9930);
    public static final PlatformLogicalVersion v9_7_0 = PlatformLogicalVersion.fromBuild(9, 7, 0, 10496);
    public static final PlatformLogicalVersion v9_7_1 = PlatformLogicalVersion.fromBuild(9, 7, 1, 10800);
    public static final PlatformLogicalVersion v9_7_2 = PlatformLogicalVersion.fromBuild(9, 7, 2, 11000);
    public static final PlatformLogicalVersion v10_0_0 = PlatformLogicalVersion.fromBuild(10, 0, 0, 11600);
    public static final PlatformLogicalVersion v10_0_1 = PlatformLogicalVersion.fromBuild(10, 0, 1, 11800);
    public static final PlatformLogicalVersion v10_1_0 = PlatformLogicalVersion.fromBuild(10, 1, 0, 12600);
    public static final PlatformLogicalVersion v10_1_1 = PlatformLogicalVersion.fromBuild(10, 1, 1, 12800);
    public static final PlatformLogicalVersion v10_2_0 = PlatformLogicalVersion.fromBuild(10, 2, 0, 13800);
    public static final PlatformLogicalVersion v10_2_0_PATCH2 = PlatformLogicalVersion.fromBuild(10, 2, 0, 13820);
    public static final PlatformLogicalVersion v11_0_0 = PlatformLogicalVersion.fromBuild(11, 0, 0, 14800);
    public static final PlatformLogicalVersion v11_0_1 = PlatformLogicalVersion.fromBuild(11, 0, 1, 14890);
    public static final PlatformLogicalVersion v12_0_0 = PlatformLogicalVersion.fromBuild(12, 0, 0, 15790);
    public static final PlatformLogicalVersion v12_0_1 = PlatformLogicalVersion.fromBuild(12, 0, 1, 16600);
    public static final PlatformLogicalVersion v12_1_0 = PlatformLogicalVersion.fromBuild(12, 1, 0, 17000);
    public static final PlatformLogicalVersion v12_1_1 = PlatformLogicalVersion.fromBuild(12, 1, 1, 17100);
    public static final PlatformLogicalVersion v12_2_0 = PlatformLogicalVersion.fromBuild(12, 2, 0, 18000);
    public static final PlatformLogicalVersion v12_3_0 = PlatformLogicalVersion.fromBuild(12, 3, 0, 19000);
    public static final PlatformLogicalVersion v12_3_0_PATCH4 = PlatformLogicalVersion.fromBuild(12, 3, 0, 19040);
    public static final PlatformLogicalVersion v12_3_1 = PlatformLogicalVersion.fromBuild(12, 3, 1, 19300);
    public static final PlatformLogicalVersion v14_0_0 = PlatformLogicalVersion.fromBuild(14, 0, 0, 20000);
    public static final PlatformLogicalVersion v14_0_1 = PlatformLogicalVersion.fromBuild(14, 0, 1, 20100);
    public static final PlatformLogicalVersion v14_2_0 = PlatformLogicalVersion.fromBuild(14, 2, 0, 20400);
    public static final PlatformLogicalVersion v14_5_0 = PlatformLogicalVersion.fromVersion(14, 5, 0);

    public static PlatformLogicalVersion getLogicalVersion() {
        return LOGICAL_VERSION;
    }

    public PlatformLogicalVersion() {
    }

    private PlatformLogicalVersion(int majorVersion, int minorVersion, int servicePackVersion, int buildNumber, int subBuildNumber) {
        this._majorVersion = (byte)majorVersion;
        this._minorVersion = (byte)minorVersion;
        this._servicePackVersion = (byte)servicePackVersion;
        this._buildNumber = buildNumber;
        this._subBuildNumber = subBuildNumber;
    }

    static PlatformLogicalVersion fromBuild(int majorVersion, int minorVersion, int servicePackVersion, int buildNumber) {
        return PlatformLogicalVersion.fromBuild(majorVersion, minorVersion, servicePackVersion, buildNumber, 0);
    }

    static PlatformLogicalVersion fromBuild(int majorVersion, int minorVersion, int servicePackVersion, int buildNumber, int subBuildNumber) {
        return new PlatformLogicalVersion(majorVersion, minorVersion, servicePackVersion, buildNumber, subBuildNumber);
    }

    static PlatformLogicalVersion fromVersion(int majorVersion, int minorVersion, int servicePackVersion) {
        return PlatformLogicalVersion.fromVersion(majorVersion, minorVersion, servicePackVersion, "", 0);
    }

    static PlatformLogicalVersion fromVersion(int majorVersion, int minorVersion, int servicePackVersion, String patchId, int patchNum) {
        return new PlatformLogicalVersion(majorVersion, minorVersion, servicePackVersion, 30000 + patchNum, patchId.hashCode());
    }

    private static PlatformLogicalVersion fromVersion(PlatformVersion version) {
        return PlatformLogicalVersion.fromVersion(version.getMajorVersion(), version.getMinorVersion(), version.getServicePackVersion(), version.getPatchId(), version.getPatchNumber());
    }

    @Override
    public int compareTo(PlatformLogicalVersion other) {
        if (this._buildNumber >= 30000 && this._majorVersion >= 14) {
            int code = Integer.compare(this._majorVersion, other._majorVersion);
            if (code != 0) {
                return code;
            }
            code = Integer.compare(this._minorVersion, other._minorVersion);
            if (code != 0) {
                return code;
            }
            return Integer.compare(this._servicePackVersion, other._servicePackVersion);
        }
        int code = Integer.compare(this._buildNumber, other._buildNumber);
        if (code != 0) {
            return code;
        }
        return Integer.compare(this._subBuildNumber, other._subBuildNumber);
    }

    public boolean patchSameOrGreater(PlatformLogicalVersion other) {
        return this._majorVersion == other._majorVersion && this._minorVersion == other._minorVersion && this._servicePackVersion == other._servicePackVersion && this._subBuildNumber == other._subBuildNumber && this._buildNumber >= other._buildNumber;
    }

    public boolean lessThan(PlatformLogicalVersion otherVersion) {
        return this.compareTo(otherVersion) < 0;
    }

    public boolean greaterOrEquals(PlatformLogicalVersion otherVersion) {
        return this.compareTo(otherVersion) >= 0;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        byte version = in.readByte();
        if (version != -127) {
            throw new UnmarshalException("Requested version [" + version + "] does not match local version [" + -127 + "]. Please make sure you are using the same version on both ends, local version is " + PlatformVersion.getOfficialVersion());
        }
        this.read(in);
    }

    public void read(ObjectInput in) throws IOException {
        this._majorVersion = in.readByte();
        this._minorVersion = in.readByte();
        this._servicePackVersion = in.readByte();
        this._buildNumber = in.readInt();
        this._subBuildNumber = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeByte(-127);
        this.write(out);
    }

    public void write(ObjectOutput out) throws IOException {
        out.writeByte(this._majorVersion);
        out.writeByte(this._minorVersion);
        out.writeByte(this._servicePackVersion);
        out.writeInt(this._buildNumber);
        out.writeInt(this._subBuildNumber);
    }

    public String toString() {
        return "" + this._majorVersion + "." + this._minorVersion + "." + this._servicePackVersion + "." + this._buildNumber + "-" + this._subBuildNumber;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this._buildNumber;
        result = 31 * result + this._majorVersion;
        result = 31 * result + this._minorVersion;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlatformLogicalVersion other = (PlatformLogicalVersion)obj;
        if (this._buildNumber != other._buildNumber) {
            return false;
        }
        if (this._majorVersion != other._majorVersion) {
            return false;
        }
        if (this._minorVersion != other._minorVersion) {
            return false;
        }
        if (this._servicePackVersion != other._servicePackVersion) {
            return false;
        }
        return this._subBuildNumber == other._subBuildNumber;
    }

    public static PlatformLogicalVersion minimum(PlatformLogicalVersion version1, PlatformLogicalVersion version2) {
        if (version1.lessThan(version2)) {
            return version1;
        }
        return version2;
    }
}

