/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.internal.version;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.logger.LoggerSystemInfo;
import com.gigaspaces.start.ProductType;
import java.io.File;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.ErrorManager;

@InternalApi
public class PlatformVersion {
    private static final PlatformVersion instance = new PlatformVersion(PlatformVersion.getVersionPropertiesFromFile("com/gigaspaces/internal/version/PlatformVersion.properties"));
    private final String id;
    private final String version;
    private final String officialVersion;
    private final byte majorVersion;
    private final byte minorVersion;
    private final byte spVersion;
    private final String tag;
    private final Properties shas;
    private final String revision;
    private final String productHelpUrl;
    private final ProductType productType;
    private final String patchId;
    private final int patchNumber;

    public PlatformVersion(Properties properties) {
        this.id = properties.getProperty("gs.build-name");
        this.version = PlatformVersion.extractPrefix(this.id, "-");
        this.productType = PlatformVersion.isInsightEdge() ? ProductType.InsightEdge : ProductType.XAP;
        this.officialVersion = "GigaSpaces " + (Object)((Object)this.productType) + " " + this.id;
        this.tag = properties.getProperty("gs.git-tag");
        this.shas = PlatformVersion.extractPropertiesByPrefix(properties, "gs.git-sha.");
        this.revision = PlatformVersion.initRevision(this.tag, this.shas);
        String[] patchTokens = PlatformVersion.extractPatchTokens(this.id, this.version);
        this.patchId = patchTokens[0];
        this.patchNumber = Integer.parseInt(patchTokens[1]);
        String[] versionTokens = this.version.split("\\.");
        this.majorVersion = Byte.parseByte(versionTokens[0]);
        this.minorVersion = Byte.parseByte(versionTokens[1]);
        this.spVersion = Byte.parseByte(versionTokens[2]);
        this.productHelpUrl = "https://docs.gigaspaces.com/" + this.majorVersion + "." + this.minorVersion;
    }

    private static String extractPrefix(String s, String separator) {
        int pos = s.indexOf(separator);
        return pos == -1 ? s : s.substring(0, pos);
    }

    private static String[] extractPatchTokens(String id, String version) {
        String[] stringArray;
        String prefix = version + "-patch-";
        if (id.startsWith(prefix)) {
            stringArray = id.replace(prefix, "").split("-");
        } else {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "";
            stringArray = stringArray2;
            stringArray2[1] = "0";
        }
        return stringArray;
    }

    private static boolean isInsightEdge() {
        return new File(LoggerSystemInfo.xapHome + File.separator + "insightedge").exists();
    }

    private static String initRevision(String tag, Properties shas) {
        if (tag != null && !tag.equals("Unspecified")) {
            return tag;
        }
        return !shas.isEmpty() ? shas.toString() : "unknown";
    }

    private static Properties extractPropertiesByPrefix(Properties properties, String prefix) {
        Properties result = new Properties();
        properties.entrySet().stream().filter(p -> p.getKey().toString().startsWith(prefix)).forEach(p -> result.put(p.getKey().toString().substring(prefix.length()), p.getValue()));
        return result;
    }

    public static PlatformVersion getInstance() {
        return instance;
    }

    public static void main(String[] args) {
        System.out.println(PlatformVersion.getOfficialVersion());
    }

    private static Properties getVersionPropertiesFromFile(String path) {
        Properties properties = new Properties();
        try {
            InputStream inputStream = PlatformVersion.class.getClassLoader().getResourceAsStream(path);
            if (inputStream != null) {
                properties.load(inputStream);
                inputStream.close();
            }
        }
        catch (Throwable t) {
            ErrorManager errorManager = new ErrorManager();
            errorManager.error("Failed to load version properties from " + path, new Exception(t), 4);
        }
        return properties;
    }

    public ProductType getProductType() {
        return this.productType;
    }

    public byte getMajorVersion() {
        return this.majorVersion;
    }

    public byte getMinorVersion() {
        return this.minorVersion;
    }

    byte getServicePackVersion() {
        return this.spVersion;
    }

    String getPatchId() {
        return this.patchId;
    }

    int getPatchNumber() {
        return this.patchNumber;
    }

    public String getId() {
        return this.id;
    }

    public static String getOfficialVersion() {
        return PlatformVersion.instance.officialVersion;
    }

    public static String getVersion() {
        return PlatformVersion.instance.version;
    }

    public static String getRevision() {
        return PlatformVersion.instance.revision;
    }

    public static String getProductHelpUrl() {
        return PlatformVersion.instance.productHelpUrl;
    }
}

