/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.logger;

import com.gigaspaces.logger.BackupPolicy;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.LogManager;

public class DeleteBackupPolicy
implements BackupPolicy {
    private static final String SYSPROP_PROP_PREFIX = DeleteBackupPolicy.class.getName() + ".";
    private static final String PERIOD_PROPERTY = "period";
    private static final String BACKUP_PROPERTY = "backup";
    private static final int PERIOD_DEFAULT = 30;
    private static final int BACKUP_DEFAULT = 10;
    private static final long DAYS_TO_MILLIS = 86400000L;
    private final List<File> files;
    private final long period;
    private final int backup;

    public DeleteBackupPolicy() {
        LogManager manager = LogManager.getLogManager();
        this.period = 86400000L * (long)this.getPeriodProperty(this.resolvePolicyProperty(manager, PERIOD_PROPERTY));
        this.backup = this.getBackupProperty(this.resolvePolicyProperty(manager, BACKUP_PROPERTY));
        this.files = new ArrayList<File>(this.backup);
    }

    private String resolvePolicyProperty(LogManager manager, String property) {
        String propertyKey = SYSPROP_PROP_PREFIX + property;
        return System.getProperty(propertyKey, manager.getProperty(propertyKey));
    }

    private int getPeriodProperty(String property) {
        if (property == null) {
            return 30;
        }
        return Integer.valueOf(property);
    }

    private int getBackupProperty(String property) {
        if (property == null) {
            return 10;
        }
        return Integer.valueOf(property);
    }

    @Override
    public void track(File file) {
        if (!this.files.contains(file)) {
            this.files.add(file);
        }
        if (!this.exceededBackupsThreshold()) {
            return;
        }
        long today = System.currentTimeMillis();
        Iterator<File> iter = this.files.iterator();
        while (this.exceededBackupsThreshold() && iter.hasNext()) {
            File f = iter.next();
            if (!f.exists()) {
                iter.remove();
                continue;
            }
            if (f.lastModified() + this.period > today) break;
            try {
                f.delete();
            }
            catch (Exception e) {
                System.err.println("Failed to delete file: " + f.getAbsolutePath() + " Caught: " + e);
                e.printStackTrace(System.err);
            }
            iter.remove();
        }
    }

    private boolean exceededBackupsThreshold() {
        return this.files.size() > this.backup;
    }
}

