/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.logger;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.logger.LogHelper;
import com.gigaspaces.logger.RollingFileHandler;
import com.gigaspaces.logger.RollingFileHandlerConfigurer;
import com.gigaspaces.start.SystemInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

@InternalApi
public class GSLogConfigLoader {
    private final Properties _props = new Properties();
    private static final String COM_GS_LOGGING = "com.gigaspaces.logging";
    private static final boolean _loggerConfig = Boolean.getBoolean("com.gigaspaces.logging.level.config");
    @Deprecated
    public static final String GIGASPACES_PATTERN_PREFIX = "gigaspaces";
    @Deprecated
    public static final String PATTERN_SUFFIX = "_%g_%u.log";
    @Deprecated
    public static final String SPACE_FILE_PATTERN_NAME = "gigaspaces_%g_%u.log";
    @Deprecated
    private static String _filePatternName = "gigaspaces_%g_%u.log";
    private static GSLogConfigLoader _loader = null;

    private GSLogConfigLoader(Properties overridedProperties) {
        this.loadGsLoggingPropertiesFile();
        this.overridePropertiesWithSystemProperties();
        this.overridePropertiesWithProvidedProperties(overridedProperties);
        boolean needToLoadHandlers = this.removeNonSystemClassLoaderHandlers();
        this.applyLoadedProperties();
        if (needToLoadHandlers) {
            this.loadHandlers();
        }
    }

    public static synchronized boolean isInitialized() {
        return _loader != null;
    }

    public static synchronized void reset() {
        _loader = null;
    }

    public static synchronized GSLogConfigLoader getLoader() {
        return GSLogConfigLoader.getLoader((Properties)null);
    }

    public static synchronized GSLogConfigLoader getLoader(Properties overridedProperties) {
        if (_loader == null && LogHelper.ENABLED) {
            _loader = new GSLogConfigLoader(overridedProperties);
        }
        return _loader;
    }

    public static synchronized GSLogConfigLoader getLoader(String fileHanderPattern) {
        RollingFileHandlerConfigurer.setServiceProperty(fileHanderPattern, false);
        _filePatternName = fileHanderPattern;
        return GSLogConfigLoader.getLoader();
    }

    private void loadGsLoggingPropertiesFile() {
        boolean loaded = this.loadGsLoggingPropertiesFileFromJavaLoggingConfiguration();
        if (!loaded) {
            loaded = this.loadGsLoggingPropertiesFileFromClasspath();
        }
        if (!loaded) {
            loaded = this.loadGsLoggingPropertiesFileFromComGsHomePath();
        }
        boolean loadedExt = this.loadGsExtLoggingPropertiesFileFromClasspath();
        if (!loaded && !loadedExt && _loggerConfig) {
            LogHelper.println(COM_GS_LOGGING, Level.CONFIG, "Not using any logging configuration file");
        }
    }

    private boolean loadGsLoggingPropertiesFileFromJavaLoggingConfiguration() {
        String javaUtilLoggingConfigFile = System.getProperty("java.util.logging.config.file");
        if (javaUtilLoggingConfigFile == null) {
            return false;
        }
        return this.loadGsLoggingPropertiesFileFromFullPath(javaUtilLoggingConfigFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadGsLoggingPropertiesFileFromFullPath(String fileName) {
        InputStream in = null;
        File logConfigFile = new File(fileName);
        try {
            if (logConfigFile.exists() && logConfigFile.canRead()) {
                in = logConfigFile.toURI().toURL().openStream();
                this._props.load(in);
                if (_loggerConfig) {
                    LogHelper.println(COM_GS_LOGGING, Level.CONFIG, "Loaded logging configuration file from: " + logConfigFile.getAbsolutePath());
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            if (_loggerConfig) {
                LogHelper.println(COM_GS_LOGGING, Level.CONFIG, "Failed to load logging configuration file from: " + logConfigFile.getAbsolutePath(), e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean loadGsLoggingPropertiesFileFromClasspath() {
        return this.loadLoggingFileFromClasspath("config/log/xap_logging.properties");
    }

    private boolean loadGsExtLoggingPropertiesFileFromClasspath() {
        return this.loadLoggingFileFromClasspath("config/log/xap_logging_ext.properties");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean loadLoggingFileFromClasspath(String fileName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = GSLogConfigLoader.class.getClassLoader();
        }
        InputStream in = null;
        try {
            in = classLoader.getResourceAsStream(fileName);
            if (in != null) {
                this._props.load(in);
                if (_loggerConfig) {
                    File f = new File(classLoader.getResource(fileName).getFile());
                    LogHelper.println(COM_GS_LOGGING, Level.CONFIG, "Loaded logging configuration file from: " + f.getAbsolutePath());
                }
                boolean f = true;
                return f;
            }
            boolean f = false;
            return f;
        }
        catch (IOException e) {
            if (_loggerConfig) {
                LogHelper.println(COM_GS_LOGGING, Level.CONFIG, "Failed to load configuration file [" + fileName + "] from classpath", e);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private boolean loadGsLoggingPropertiesFileFromComGsHomePath() {
        return this.loadGsLoggingPropertiesFileFromFullPath(SystemInfo.singleton().getXapHome() + File.separator + "config/log/xap_logging.properties");
    }

    private void overridePropertiesWithSystemProperties() {
        Enumeration<Object> keys = this._props.keys();
        while (keys.hasMoreElements()) {
            String key = String.valueOf(keys.nextElement());
            String newValue = System.getProperty(key);
            if (newValue == null) continue;
            Object prevVal = this._props.put(key, newValue);
            if (!_loggerConfig) continue;
            LogHelper.println(COM_GS_LOGGING, Level.CONFIG, "override: " + key + "=" + newValue + (prevVal != null ? " (was " + prevVal + ")" : ""));
        }
    }

    private void overridePropertiesWithProvidedProperties(Properties overridedProperties) {
        if (overridedProperties == null) {
            return;
        }
        for (Map.Entry<Object, Object> entry : overridedProperties.entrySet()) {
            this._props.put(entry.getKey(), entry.getValue());
        }
    }

    private void applyLoadedProperties() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            this._props.store(os, "");
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            LogManager.getLogManager().readConfiguration(is);
        }
        catch (Exception e) {
            LogHelper.println(COM_GS_LOGGING, Level.SEVERE, "Failed to configure java.util.logging", e);
        }
    }

    private boolean removeNonSystemClassLoaderHandlers() {
        String handlers;
        if (RollingFileHandler.class.getClassLoader() != ClassLoader.getSystemClassLoader() && (handlers = this._props.getProperty("handlers")) != null) {
            String onlyNonCustomHandlers = handlers.replace(RollingFileHandler.class.getName(), "");
            this._props.setProperty("handlers", onlyNonCustomHandlers);
            return true;
        }
        return false;
    }

    private void loadHandlers() {
        try {
            Class<Handler> handlerClass = RollingFileHandler.class.asSubclass(Handler.class);
            try {
                LogManager logManager = LogManager.getLogManager();
                Logger rootLogger = logManager.getLogger("");
                Handler handler = handlerClass.newInstance();
                rootLogger.addHandler(handler);
            }
            catch (Exception e) {
                LogHelper.println(COM_GS_LOGGING, Level.WARNING, "Configuration error using handler class: " + handlerClass, e);
            }
        }
        catch (ClassCastException e) {
            LogHelper.println(COM_GS_LOGGING, Level.WARNING, "Configuration error", e);
        }
    }
}

