/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.logger;

import com.gigaspaces.api.InternalApi;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

@InternalApi
public class LogHelper {
    public static final boolean ENABLED = !Boolean.getBoolean("com.gs.logging.disabled");
    private static final MessageFormat messageFormat = new MessageFormat("{0,date,yyyy-MM-dd HH:mm:ss,SSS}");

    public static boolean log(String logName, Level level, String message, Throwable thrown) {
        LogManager logManager = LogManager.getLogManager();
        Logger logger = logManager.getLogger(logName);
        if (logger != null && logger.isLoggable(level)) {
            logger.log(level, message, thrown);
            return true;
        }
        String key = logName + ".level";
        String levelOverride = System.getProperty(key, logManager.getProperty(key));
        if (levelOverride != null) {
            Level levelParsed = Level.parse(levelOverride);
            if (level.intValue() < levelParsed.intValue() || level.equals(Level.OFF)) {
                return false;
            }
            LogHelper.println(logName, level, message, thrown);
        }
        return false;
    }

    public static void println(String logName, Level level, String message) {
        LogHelper.println(logName, level, message, null);
    }

    public static void println(String logName, Level level, String message, Throwable t) {
        String dateTimeAsString = messageFormat.format(new Object[]{new Date()});
        String stackTrace = "";
        if (t != null) {
            stackTrace = "; Caught: " + t + "\n" + LogHelper.getStackTrace(t);
        }
        String msg = dateTimeAsString + " " + level + " [" + logName + "] - " + message + stackTrace;
        if (Level.WARNING.equals(level) || Level.SEVERE.equals(level)) {
            System.err.println(msg);
        } else {
            System.out.println(msg);
        }
    }

    private static String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }

    public static long getCurrTimeIfNeeded(Logger logger, Level level) {
        return logger.isLoggable(level) ? System.currentTimeMillis() : 0L;
    }

    public static void logDuration(Logger logger, Level level, long startTime, String message) {
        long duration = System.currentTimeMillis() - startTime;
        logger.log(level, message + " [Duration = " + duration + "ms]");
    }
}

