/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.logger;

import com.gigaspaces.start.Locator;
import java.io.File;
import java.lang.management.ManagementFactory;

public class LoggerSystemInfo {
    public static final String xapHome = LoggerSystemInfo.findXapHome();
    public static final long processId = LoggerSystemInfo.findProcessId();

    private static String findXapHome() {
        String result = System.getProperty("com.gs.home");
        if (result == null) {
            result = System.getenv("XAP_HOME");
        }
        if (result == null) {
            result = Locator.deriveDirectories().getProperty("com.gs.home");
        }
        if (result == null) {
            result = ".";
        }
        if (result.endsWith(File.separator)) {
            result = result + File.separator;
        }
        result = LoggerSystemInfo.trimSuffix(result, File.separator);
        System.setProperty("com.gs.home", result);
        return result;
    }

    private static long findProcessId() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int pos = name.indexOf(64);
        if (pos < 1) {
            return -1L;
        }
        try {
            return Long.parseLong(name.substring(0, pos));
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private static String trimSuffix(String s, String suffix) {
        return s.endsWith(suffix) ? s.substring(0, s.length() - suffix.length()) : s;
    }
}

