/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.logger;

import java.io.IOException;
import java.io.OutputStream;

class MeteredStream
extends OutputStream {
    OutputStream out;
    int written;

    MeteredStream(OutputStream out, int written) {
        this.out = out;
        this.written = written;
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
        ++this.written;
    }

    @Override
    public void write(byte[] buff) throws IOException {
        this.out.write(buff);
        this.written += buff.length;
    }

    @Override
    public void write(byte[] buff, int off, int len) throws IOException {
        this.out.write(buff, off, len);
        this.written += len;
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }
}

