/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.logger;

import com.gigaspaces.logger.BackupPolicy;
import com.gigaspaces.logger.GSSimpleFormatter;
import com.gigaspaces.logger.LogHelper;
import com.gigaspaces.logger.LoggerSystemInfo;
import com.gigaspaces.logger.MeteredStream;
import com.gigaspaces.logger.NullBackupPolicy;
import com.gigaspaces.logger.SizeRollingPolicy;
import com.gigaspaces.logger.TimeRollingPolicy;
import com.gigaspaces.start.XapNetworkInfo;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.StreamHandler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RollingFileHandler
extends StreamHandler {
    private static boolean monitorCreatedFiles = false;
    private static final List<File> filesCreated = new ArrayList<File>();
    static final Properties overrides = new Properties();
    protected final String HANDLER_PROP_PREFIX = this.getClass().getName() + ".";
    protected static final String LEVEL_PROP = "level";
    protected static final String FORMATTER_PROP = "formatter";
    protected static final String FILENAME_PATTERN_PROP = "filename-pattern";
    protected static final String SIZE_ROLLING_POLICY_PROP = "size-rolling-policy";
    protected static final String TIME_ROLLING_POLICY_PROP = "time-rolling-policy";
    protected static final String BACKUP_POLICY_PROP = "backup-policy";
    protected static final String APPEND_PROP = "append";
    protected static final String DEBUG_LEVEL = "debug-level";
    protected final String FILENAME_PATTTERN_PLACEHOLDER_PREFIX = this.HANDLER_PROP_PREFIX + "filename-pattern" + ".";
    protected static final String HOMEDIR_PROP = "homedir";
    protected static final String HOST_PROP = "host";
    protected static final String PID_PROP = "pid";
    protected static final String SERVICE_PROP = "service";
    protected static final String DATE_PROP = "date";
    private static final Pattern FILE_PATTERN_PROPERTY_MATCHER = Pattern.compile("\\{([^\\{]*)\\}");
    private String filenamePattern;
    private SizeRollingPolicy sizeRollingPolicy;
    private TimeRollingPolicy timeRollingPolicy;
    private BackupPolicy backupPolicy;
    private boolean append;
    private Level debugLevel;
    protected static final String DATE_PATTERN_DEFAULT = "yyyy-MM-dd~HH.mm";
    protected static final String FILENAME_PATTERN_DEFAULT = "{homedir}/logs/{date,yyyy-MM-dd~HH.mm}-gigaspaces-{service}-{host}-{pid}.log";
    protected static final int SIZE_ROLLING_POLICY_DEFAULT = 2000000;
    protected static final String TIME_ROLLING_POLICY_DEFAULT = "daily";
    protected static final String FILE_APPEND_DEFAULT = "false";
    protected static final String DEBUG_LEVEL_DEFAULT = "CONFIG";
    private boolean corruptedOutputStream = false;

    public static void monitorCreatedFiles() {
        monitorCreatedFiles = true;
    }

    public static boolean isMonitoringCreatedFiles() {
        return monitorCreatedFiles;
    }

    public static File[] filesCreated() {
        return filesCreated.toArray(new File[filesCreated.size()]);
    }

    public RollingFileHandler() {
        this.configure();
        this.configureOutputStream();
    }

    protected void configure() {
        LogManager manager = LogManager.getLogManager();
        this.setDefaultLevelIfNull(this.resolveLoggerProperty(manager, LEVEL_PROP));
        this.setDefaultFormatterIfNull(this.resolveLoggerProperty(manager, FORMATTER_PROP));
        this.setFilenamePattern(this.resolveLoggerProperty(manager, FILENAME_PATTERN_PROP));
        this.setSizeRollingPolicy(this.resolveLoggerProperty(manager, SIZE_ROLLING_POLICY_PROP));
        this.setTimeRollingPolicy(this.resolveLoggerProperty(manager, TIME_ROLLING_POLICY_PROP));
        this.setBackupPolicy(this.resolveLoggerProperty(manager, BACKUP_POLICY_PROP));
        this.setFileAppend(this.resolveLoggerProperty(manager, APPEND_PROP));
        this.setDebugLevel(this.resolveLoggerProperty(manager, DEBUG_LEVEL));
    }

    private String resolveLoggerProperty(LogManager manager, String property) {
        String propertyKey = this.HANDLER_PROP_PREFIX + property;
        return System.getProperty(propertyKey, manager.getProperty(propertyKey));
    }

    private void setDefaultLevelIfNull(String level) {
        if (level == null) {
            this.setLevel(Level.ALL);
        }
    }

    private void setDefaultFormatterIfNull(String formatter) {
        if (formatter == null) {
            this.setFormatter(new GSSimpleFormatter());
        }
    }

    private void setFilenamePattern(String filenamePattern) {
        if (filenamePattern == null) {
            filenamePattern = FILENAME_PATTERN_DEFAULT;
        }
        this.filenamePattern = filenamePattern = filenamePattern.replace("/", File.separator);
    }

    private void setSizeRollingPolicy(String sizeLimit) {
        int limit = 2000000;
        if (sizeLimit != null && (limit = Integer.valueOf(sizeLimit).intValue()) < 0) {
            limit = 0;
        }
        this.sizeRollingPolicy = new SizeRollingPolicy(limit);
    }

    private void setTimeRollingPolicy(String policy) {
        if (policy == null) {
            policy = TIME_ROLLING_POLICY_DEFAULT;
        }
        this.timeRollingPolicy = new TimeRollingPolicy(policy);
    }

    private void setBackupPolicy(String policy) {
        if (policy == null) {
            policy = NullBackupPolicy.class.getName();
        }
        try {
            BackupPolicy newInstance;
            Class<BackupPolicy> backupPolicyClass = Class.forName(policy).asSubclass(BackupPolicy.class);
            this.backupPolicy = newInstance = backupPolicyClass.newInstance();
        }
        catch (Exception ex) {
            this.reportError("Can't create an instance of BackupPolicy class:" + policy, ex, 0);
            this.backupPolicy = new NullBackupPolicy();
        }
    }

    private void setFileAppend(String append) {
        if (append == null) {
            append = FILE_APPEND_DEFAULT;
        }
        this.append = Boolean.parseBoolean(append);
    }

    private void setDebugLevel(String level) {
        if (level == null) {
            level = DEBUG_LEVEL_DEFAULT;
        }
        this.debugLevel = Level.parse(level);
    }

    private boolean isDebuggable(Level level) {
        return level.intValue() >= this.debugLevel.intValue() && this.debugLevel != Level.OFF;
    }

    private void configureOutputStream() {
        String filename = this.generateFilename();
        File file = null;
        try {
            file = this.acquireUniqueFile(filename);
            if (this.isDebuggable(Level.CONFIG)) {
                LogHelper.println("com.gigaspaces.logger", Level.CONFIG, "Log file: " + file.getAbsolutePath());
            }
            FileOutputStream fout = new FileOutputStream(file, this.append);
            BufferedOutputStream bout = new BufferedOutputStream(fout);
            MeteredStream meteredStream = new MeteredStream(bout, (int)file.length());
            this.setOutputStream(meteredStream);
            this.sizeRollingPolicy.setMeteredStream(meteredStream);
            this.timeRollingPolicy.setTimestamp();
            this.backupPolicy.track(file);
            if (monitorCreatedFiles) {
                filesCreated.add(0, file);
            }
        }
        catch (IOException ioe) {
            String filepath = file != null ? file.getAbsolutePath() : filename;
            this.reportError("Failed while configuring output file: " + filepath, ioe, 4);
            this.corruptedOutputStream = true;
        }
    }

    private String generateFilename() {
        String filename = this.filenamePattern;
        Matcher matcher = FILE_PATTERN_PROPERTY_MATCHER.matcher(filename);
        while (matcher.find()) {
            String propertyName = matcher.group(1);
            String propertyValue = this.resolveProperty(propertyName);
            if (propertyValue == null) {
                this.reportError("Could not find system property specified in log filename pattern '" + propertyName + "'", new RuntimeException(), 5);
                continue;
            }
            if (!propertyName.equals(HOMEDIR_PROP)) {
                propertyValue = this.removeIllegalFileCharacters(propertyValue);
            }
            filename = filename.substring(0, matcher.start()) + propertyValue + filename.substring(matcher.end());
            matcher.reset(filename);
        }
        return filename;
    }

    private String resolveProperty(String propertyName) {
        try {
            String propertyValue = System.getProperty(this.FILENAME_PATTTERN_PLACEHOLDER_PREFIX + propertyName);
            if (propertyValue != null) {
                return propertyValue;
            }
            propertyValue = overrides.getProperty(propertyName);
            if (propertyValue != null) {
                return propertyValue;
            }
            if (propertyName.equals(HOMEDIR_PROP)) {
                return LoggerSystemInfo.xapHome;
            }
            if (propertyName.equals(HOST_PROP)) {
                return XapNetworkInfo.getInstance().getHostId();
            }
            if (propertyName.equals(PID_PROP)) {
                return "" + LoggerSystemInfo.processId;
            }
            if (propertyName.startsWith(DATE_PROP)) {
                return RollingFileHandler.getCurrDate(propertyName);
            }
            return propertyName;
        }
        catch (Throwable t) {
            this.reportError("Failed acquiring property value for: " + propertyName, new Exception(t), 5);
            return "";
        }
    }

    private static String getCurrDate(String propertyName) {
        int indexOf = propertyName.indexOf(44);
        String dateFormat = indexOf != -1 ? propertyName.substring(indexOf + 1, propertyName.length()) : DATE_PATTERN_DEFAULT;
        return new SimpleDateFormat(dateFormat).format(new Date());
    }

    private String removeIllegalFileCharacters(String string) {
        return string.replaceAll("/|\\\\|:|\\*|\\?|\"|<|>|\\||\\s", "");
    }

    private File acquireUniqueFile(String originalFilename) throws IOException {
        String filename = originalFilename;
        int unique = 0;
        while (true) {
            File f = new File(filename);
            this.createParentDirectories(f);
            boolean created = f.createNewFile();
            if (created) {
                return f;
            }
            if (this.append && !this.sizeRollingPolicy.hasReachedLimit(f)) {
                return f;
            }
            ++unique;
            if (originalFilename.endsWith(".log")) {
                filename = originalFilename.replace(".log", "__" + unique + ".log");
                continue;
            }
            filename = originalFilename + "__" + unique;
        }
    }

    private void createParentDirectories(File file) {
        if (!file.exists()) {
            String path = file.getAbsolutePath();
            String dirs = path.substring(0, path.lastIndexOf(File.separator));
            File dir = new File(dirs);
            if (dir.exists()) {
                return;
            }
            if (!dir.mkdirs()) {
                this.reportError("Failed to create directories: " + dir.getAbsolutePath(), new IOException("The system cannot find the path specified: " + dir.getAbsolutePath()), 4);
            }
        }
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (this.corruptedOutputStream) {
            return;
        }
        if (this.sizeRollingPolicy.hasReachedLimit() || this.timeRollingPolicy.needsRollover()) {
            this.configureOutputStream();
        }
        super.publish(record);
        super.flush();
    }
}

