/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.logger;

import com.gigaspaces.api.InternalApi;
import java.util.Calendar;
import java.util.GregorianCalendar;

@InternalApi
public class TimeRollingPolicy {
    private final TimeBoundry timeBoundry;
    private Calendar nextRollover;

    TimeRollingPolicy(String policy) {
        String boundry = policy.trim().toUpperCase();
        this.timeBoundry = TimeBoundry.valueOf(boundry);
    }

    void setTimestamp() {
        Calendar cal = GregorianCalendar.getInstance();
        switch (this.timeBoundry) {
            case DAILY: {
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(5, 1);
                break;
            }
            case WEEKLY: {
                cal.set(7, cal.getFirstDayOfWeek());
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(3, 1);
                break;
            }
            case MONTHLY: {
                cal.set(5, 1);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.add(2, 1);
                break;
            }
            case YEARLY: {
                cal.set(5, 1);
                cal.set(11, 0);
                cal.set(12, 0);
                cal.set(13, 0);
                cal.set(14, 0);
                cal.set(2, 0);
                cal.add(1, 1);
            }
        }
        this.nextRollover = cal;
    }

    boolean needsRollover() {
        Calendar now = GregorianCalendar.getInstance();
        if (now.compareTo(this.nextRollover) > 0) {
            this.setTimestamp();
            return true;
        }
        return false;
    }

    private static enum TimeBoundry {
        DAILY,
        WEEKLY,
        MONTHLY,
        YEARLY;

    }
}

