/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.logger;

import com.gigaspaces.api.InternalApi;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

@InternalApi
public class TraceableLogger
extends Logger {
    private static final int DEFAULT_TRACE_LENGTH = 100;
    private static final int OFF_VALUE = Level.OFF.intValue();
    private static final Comparator<LogRecord> comperator = new Comparator<LogRecord>(){

        @Override
        public int compare(LogRecord o1, LogRecord o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1.getMillis() == o2.getMillis()) {
                return Long.valueOf(o1.getSequenceNumber()).compareTo(o2.getSequenceNumber());
            }
            return Long.valueOf(o1.getMillis()).compareTo(o2.getMillis());
        }
    };
    private static final ConcurrentMap<String, WeakReference<TraceableLogger>> traceableLoggers = new ConcurrentHashMap<String, WeakReference<TraceableLogger>>();
    private final int _traceLoggingLevel;
    private final int _traceLength;
    private final Logger _logger;
    private final String[] _associatedLoggers;
    private final boolean _hasAssociatedLogOn;
    private final ThreadLocal<LogRecord[]> _threadTrace;
    private final LogRecord[] _globalTrace;
    private final boolean _threadLocalTraceEnabled;
    private final AtomicInteger _globalTraceIndex = new AtomicInteger();
    private final ThreadLocal<Integer> _threadLocalTraceIndex = new ThreadLocal<Integer>(){

        @Override
        protected Integer initialValue() {
            return 0;
        }
    };
    private final ReadWriteLock _rwLock = new ReentrantReadWriteLock(false);

    private TraceableLogger(String name, Logger logger, String ... associatedLoggers) {
        super(name, null);
        this._logger = logger;
        this._associatedLoggers = associatedLoggers;
        Level traceLevel = TraceableLogger.getDefaultTraceLevel(name);
        traceLevel = Level.parse(System.getProperty(name + ".level", traceLevel.getName()));
        if (traceLevel.intValue() != OFF_VALUE) {
            this.setLevel(traceLevel);
        }
        this._traceLoggingLevel = traceLevel.intValue();
        this._traceLength = Integer.getInteger(name + ".length", TraceableLogger.getDefaultTraceLength(name));
        boolean threadLocalTraceEnabled = TraceableLogger.getDefaultThreadLocalTraceEnabled(name);
        if (threadLocalTraceEnabled |= Boolean.getBoolean(name + ".thread")) {
            this._threadLocalTraceEnabled = true;
            this._threadTrace = new ThreadLocal<LogRecord[]>(){

                @Override
                protected LogRecord[] initialValue() {
                    return new LogRecord[TraceableLogger.this._traceLength];
                }
            };
        } else {
            this._threadLocalTraceEnabled = false;
            this._threadTrace = null;
        }
        this._globalTrace = new LogRecord[this._traceLength];
        boolean tempHasAssociatedLogOn = false;
        if (this._associatedLoggers != null) {
            for (String associatedLogName : this._associatedLoggers) {
                if (TraceableLogger.getLogger(associatedLogName).getTraceLevel() == OFF_VALUE) continue;
                tempHasAssociatedLogOn = true;
                break;
            }
        }
        this._hasAssociatedLogOn = tempHasAssociatedLogOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TraceableLogger getLogger(String name) {
        Class<Logger> clazz = Logger.class;
        synchronized (Logger.class) {
            TraceableLogger traceableLogger;
            TraceableLogger.removeUnusedWeakReferences();
            String traceableLoggerName = name + ".trace";
            WeakReference traceableLoggerWeakReference = (WeakReference)traceableLoggers.get(traceableLoggerName);
            if (traceableLoggerWeakReference != null && (traceableLogger = (TraceableLogger)traceableLoggerWeakReference.get()) != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return traceableLogger;
            }
            Logger logger = Logger.getLogger(name);
            TraceableLogger traceableLogger2 = new TraceableLogger(traceableLoggerName, logger, TraceableLogger.getAssociatedLoggers(name));
            traceableLoggers.put(traceableLoggerName, new WeakReference<TraceableLogger>(traceableLogger2));
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return traceableLogger2;
        }
    }

    private static void removeUnusedWeakReferences() {
        Iterator iterator = traceableLoggers.entrySet().iterator();
        while (iterator.hasNext()) {
            if (((WeakReference)iterator.next().getValue()).get() != null) continue;
            iterator.remove();
        }
    }

    @Override
    public void log(LogRecord record) {
        this._logger.log(record);
        if (record.getLevel().intValue() < this._traceLoggingLevel || this._traceLoggingLevel == OFF_VALUE) {
            return;
        }
        Integer threadTraceIndex = this._threadLocalTraceIndex.get();
        if (this._threadLocalTraceEnabled) {
            this._threadTrace.get()[threadTraceIndex.intValue() % this._traceLength] = record;
            this._threadLocalTraceIndex.set(threadTraceIndex + 1);
        }
        this.acquireAccess();
        try {
            this._globalTrace[this._globalTraceIndex.getAndIncrement() % this._traceLength] = record;
        }
        finally {
            this.releaseAccess();
        }
    }

    public int getTraceLevel() {
        return this._traceLoggingLevel;
    }

    public synchronized void showThreadTrace() {
        if (!this._threadLocalTraceEnabled) {
            throw new IllegalStateException();
        }
        if (this._traceLoggingLevel == OFF_VALUE && !this._hasAssociatedLogOn) {
            return;
        }
        this._logger.log(Level.INFO, "Trace Thread Start [" + this._traceLength + "]");
        TraceableLogger.sortTrace(this._threadTrace.get());
        for (LogRecord record : this._threadTrace.get()) {
            this.traceLogRecord(record);
        }
        if (this._associatedLoggers != null) {
            for (String associatedLogName : this._associatedLoggers) {
                TraceableLogger.getLogger(associatedLogName).showThreadTrace();
            }
        }
        this._logger.log(Level.INFO, "Trace Thread End [" + this._traceLength + "]");
    }

    public synchronized void clearThreadTrace() {
        if (!this._threadLocalTraceEnabled) {
            throw new IllegalStateException();
        }
        this._threadTrace.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void showGlobalTrace() {
        this.acquireExclusiveAccess();
        try {
            if (this._traceLoggingLevel == OFF_VALUE && !this._hasAssociatedLogOn) {
                return;
            }
            this._logger.log(Level.INFO, "Trace Global Start [" + this._traceLength + "]");
            TraceableLogger.sortTrace(this._globalTrace);
            for (LogRecord record : this._globalTrace) {
                this.traceLogRecord(record);
            }
            if (this._associatedLoggers != null) {
                for (String associatedLogName : this._associatedLoggers) {
                    TraceableLogger.getLogger(associatedLogName).showGlobalTrace();
                }
            }
            this._logger.log(Level.INFO, "Trace Global End [" + this._traceLength + "]");
        }
        finally {
            this.releaseExclusiveAccess();
        }
    }

    private static void sortTrace(LogRecord[] logRecords) {
        Arrays.sort(logRecords, comperator);
    }

    private void releaseAccess() {
        this._rwLock.readLock().unlock();
    }

    private void acquireAccess() {
        this._rwLock.readLock().lock();
    }

    private void releaseExclusiveAccess() {
        this._rwLock.writeLock().unlock();
    }

    private void acquireExclusiveAccess() {
        this._rwLock.writeLock().lock();
    }

    private void traceLogRecord(LogRecord record) {
        if (record == null) {
            return;
        }
        record.setLevel(Level.INFO);
        if (!record.getMessage().startsWith("[tid=")) {
            record.setMessage("[tid=" + record.getThreadID() + "] " + record.getMessage());
        }
        this._logger.log(record);
    }

    private static String[] getAssociatedLoggers(String name) {
        if (name.equals("com.gigaspaces.lrmi")) {
            return new String[]{"com.gigaspaces.lrmi.marshal"};
        }
        return null;
    }

    private static boolean getDefaultThreadLocalTraceEnabled(String name) {
        return !name.equals("com.gigaspaces.lrmi.classloading.trace");
    }

    private static Level getDefaultTraceLevel(String name) {
        if (name.equals("com.gigaspaces.lrmi.classloading.trace")) {
            return Level.FINEST;
        }
        if (name.equals("com.gigaspaces.replication.backlog.trace")) {
            return Level.FINEST;
        }
        return Level.OFF;
    }

    private static Integer getDefaultTraceLength(String name) {
        if (name.equals("com.gigaspaces.replication.backlog.trace")) {
            return 5000;
        }
        return 100;
    }
}

