/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationTrace;
import java.net.InetSocketAddress;

@InternalApi
public class LRMIInvocationContext {
    private static final ThreadLocal<LRMIInvocationContextHolder> invocationContexts = new ThreadLocal<LRMIInvocationContextHolder>(){

        @Override
        protected LRMIInvocationContextHolder initialValue() {
            LRMIInvocationContextHolder result = new LRMIInvocationContextHolder();
            LRMIInvocationContext context = new LRMIInvocationContext();
            context._nextContext = new LRMIInvocationContext();
            result.setContext(context);
            return result;
        }
    };
    private LRMIInvocationTrace _trace;
    private PlatformLogicalVersion _sourceLogicalVersion;
    private PlatformLogicalVersion _targetLogicalVersion;
    private ProxyWriteType _proxyWriteType = ProxyWriteType.UNCACHED;
    private InvocationStage _invocationStage;
    private LRMIInvocationContext _nextContext;
    private LRMIInvocationContext _previousContext;
    private boolean _useStubCache;
    private boolean _callbackMethod;
    private boolean _livenessPriorityEnabled;
    private boolean _customPriorityEnabled;
    private boolean _callbackMethodInNextInvocation;
    private boolean _livenessPriorityEnabledInNextInvocation;
    private boolean _customPriorityEnabledInNextInvocation;
    private InetSocketAddress _clientEndPointAddress;

    public void setTrace(LRMIInvocationTrace trace) {
        this._trace = trace;
    }

    public LRMIInvocationTrace getTrace() {
        return this._trace;
    }

    private void setSourceLogicalVersion(PlatformLogicalVersion sourceLogicalVersion) {
        this._sourceLogicalVersion = sourceLogicalVersion;
    }

    public PlatformLogicalVersion getSourceLogicalVersion() {
        return this._sourceLogicalVersion;
    }

    private void setTargetLogicalVersion(PlatformLogicalVersion targetLogicalVersion) {
        this._targetLogicalVersion = targetLogicalVersion;
    }

    public PlatformLogicalVersion getTargetLogicalVersion() {
        return this._targetLogicalVersion;
    }

    private void setProxyWriteType(ProxyWriteType proxyWriteType) {
        this._proxyWriteType = proxyWriteType;
    }

    public ProxyWriteType getProxyWriteType() {
        return this._proxyWriteType;
    }

    private void setInvocationStage(InvocationStage stage) {
        this._invocationStage = stage;
    }

    public InvocationStage getInvocationStage() {
        return this._invocationStage;
    }

    public boolean isEmpty() {
        return this._invocationStage == null;
    }

    public void setClientEndPointAddress(InetSocketAddress clientEndPointAddress) {
        this._clientEndPointAddress = clientEndPointAddress;
    }

    public InetSocketAddress getClientEndPointAddress() {
        return this._clientEndPointAddress;
    }

    public static PlatformLogicalVersion getEndpointLogicalVersion() {
        PlatformLogicalVersion result;
        LRMIInvocationContext currentContext = LRMIInvocationContext.getCurrentContext();
        if (currentContext == null || currentContext.isEmpty()) {
            return PlatformLogicalVersion.getLogicalVersion();
        }
        InvocationStage invocationStage = currentContext._invocationStage;
        switch (invocationStage) {
            case CLIENT_RECEIVE_REPLY: 
            case CLIENT_SEND_REQUEST: {
                result = currentContext._targetLogicalVersion;
                break;
            }
            case SERVER_MARSHAL_REPLY: 
            case SERVER_UNMARSHAL_REQUEST: 
            case INVOCATION_HANDLING: {
                result = currentContext._sourceLogicalVersion;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unhandled invocation stage " + (Object)((Object)currentContext._invocationStage));
            }
        }
        return result;
    }

    private LRMIInvocationContext snapshot() {
        LRMIInvocationContext newContext = this._nextContext == null ? new LRMIInvocationContext() : this._nextContext;
        newContext._previousContext = this;
        return newContext;
    }

    private LRMIInvocationContext restore() {
        this.reset();
        this._previousContext.resetNextInvocationState();
        return this._previousContext;
    }

    private void resetNextInvocationState() {
        this._livenessPriorityEnabledInNextInvocation = false;
        this._customPriorityEnabledInNextInvocation = false;
        this._callbackMethodInNextInvocation = false;
    }

    private void reset() {
        this._sourceLogicalVersion = null;
        this._targetLogicalVersion = null;
        this._trace = null;
        this._invocationStage = null;
        this._proxyWriteType = ProxyWriteType.UNCACHED;
        this._useStubCache = false;
        this._callbackMethod = false;
        this._livenessPriorityEnabled = false;
        this._customPriorityEnabled = false;
        this._clientEndPointAddress = null;
        this.resetNextInvocationState();
    }

    public static String getContextMethodShortDisplayString() {
        LRMIInvocationContext context = LRMIInvocationContext.getCurrentContext();
        if (context == null || context.isEmpty()) {
            return "no context";
        }
        LRMIInvocationTrace trace = context.getTrace();
        if (trace == null) {
            return "no trace context";
        }
        return trace.getTraceShortDisplayString();
    }

    public static String getContextMethodLongDisplayString() {
        LRMIInvocationContext context = LRMIInvocationContext.getCurrentContext();
        if (context == null || context.isEmpty()) {
            return "no context";
        }
        LRMIInvocationTrace trace = context.getTrace();
        if (trace == null) {
            return "no trace context";
        }
        return trace.getTraceLongDisplayString();
    }

    public static LRMIInvocationContext getCurrentContext() {
        return invocationContexts.get().getContext();
    }

    public static void updateContext(LRMIInvocationTrace invocationTrace, ProxyWriteType proxyWriteType, InvocationStage stage, PlatformLogicalVersion sourceLogicalVersion, PlatformLogicalVersion targetLogicalVersion, boolean createSnapshot, Boolean useStubCache, InetSocketAddress clientEndPointAddress) {
        LRMIInvocationContext actualContext;
        LRMIInvocationContextHolder holder = invocationContexts.get();
        LRMIInvocationContext invocationContext = holder.getContext();
        LRMIInvocationContext lRMIInvocationContext = actualContext = createSnapshot ? invocationContext.snapshot() : invocationContext;
        if (invocationTrace != null || createSnapshot) {
            actualContext.setTrace(invocationTrace);
        }
        if (proxyWriteType != null || createSnapshot) {
            actualContext.setProxyWriteType(proxyWriteType);
        }
        if (stage != null || createSnapshot) {
            actualContext.setInvocationStage(stage);
        }
        if (sourceLogicalVersion != null || createSnapshot) {
            actualContext.setSourceLogicalVersion(sourceLogicalVersion);
        }
        if (targetLogicalVersion != null || createSnapshot) {
            actualContext.setTargetLogicalVersion(targetLogicalVersion);
        }
        if (useStubCache != null) {
            actualContext.setUseStubCache(useStubCache);
        }
        if (clientEndPointAddress != null || createSnapshot) {
            actualContext.setClientEndPointAddress(clientEndPointAddress);
        }
        if (createSnapshot) {
            if (invocationContext._livenessPriorityEnabledInNextInvocation) {
                actualContext.setLivenessPriorityEnabled(true);
            }
            if (invocationContext._customPriorityEnabledInNextInvocation) {
                actualContext.setCustomPriorityEnabled(true);
            }
            if (invocationContext._callbackMethodInNextInvocation) {
                actualContext.setCallbackMethod(true);
            }
        }
        holder.setContext(actualContext);
    }

    public static void restoreContext() {
        LRMIInvocationContextHolder contextHolder = invocationContexts.get();
        contextHolder.setContext(contextHolder.getContext().restore());
    }

    public static void resetContext() {
        invocationContexts.get().getContext().reset();
    }

    public static void enableLivenessPriorityForNextInvocation() {
        LRMIInvocationContext.getCurrentContext()._livenessPriorityEnabledInNextInvocation = true;
    }

    public static void enableCustomPriorityForNextInvocation() {
        LRMIInvocationContext.getCurrentContext()._customPriorityEnabledInNextInvocation = true;
    }

    public static void enableCallbackModeForNextInvocation() {
        LRMIInvocationContext.getCurrentContext()._callbackMethodInNextInvocation = true;
    }

    public void setUseStubCache(boolean useStubCache) {
        this._useStubCache = useStubCache;
    }

    public boolean isUseStubCache() {
        return this._useStubCache;
    }

    private void setCallbackMethod(boolean callbackMethod) {
        this._callbackMethod = callbackMethod;
    }

    public boolean isCallbackMethod() {
        return this._callbackMethod;
    }

    private void setLivenessPriorityEnabled(boolean enabled) {
        this._livenessPriorityEnabled = enabled;
    }

    public boolean isLivenessPriorityEnabled() {
        return this._livenessPriorityEnabled;
    }

    public void setCustomPriorityEnabled(boolean customPriorityEnabled) {
        this._customPriorityEnabled = customPriorityEnabled;
    }

    public boolean isCustomPriorityEnabled() {
        return this._customPriorityEnabled;
    }

    public static InetSocketAddress getEndpointAddress() {
        LRMIInvocationContext currentContext = LRMIInvocationContext.getCurrentContext();
        if (currentContext == null || currentContext.isEmpty()) {
            return null;
        }
        return currentContext.getClientEndPointAddress();
    }

    public static enum InvocationStage {
        CLIENT_SEND_REQUEST,
        CLIENT_RECEIVE_REPLY,
        INVOCATION_HANDLING,
        SERVER_MARSHAL_REPLY,
        SERVER_UNMARSHAL_REQUEST;

    }

    public static enum ProxyWriteType {
        UNCACHED,
        CACHED_FULL,
        CACHED_LIGHT;

    }

    private static class LRMIInvocationContextHolder {
        private LRMIInvocationContext context;

        private LRMIInvocationContextHolder() {
        }

        public void setContext(LRMIInvocationContext context) {
            this.context = context;
        }

        public LRMIInvocationContext getContext() {
            return this.context;
        }
    }
}

