/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi;

import com.gigaspaces.api.InternalApi;
import java.util.Arrays;

@InternalApi
public class LRMIInvocationTrace {
    private String _method;
    private Object[] _args;
    private String _identifier;
    private final boolean _isOutgoing;

    public LRMIInvocationTrace(String method, Object[] args, String identifier, boolean isOutgoing) {
        this._method = method;
        this._args = args;
        this._identifier = identifier;
        this._isOutgoing = isOutgoing;
    }

    public String getMethod() {
        return this._method;
    }

    public LRMIInvocationTrace setMethod(String method) {
        return new LRMIInvocationTrace(method, this._args, this._identifier, this._isOutgoing);
    }

    public Object[] getArgs() {
        return this._args;
    }

    public LRMIInvocationTrace setArgs(Object[] args) {
        return new LRMIInvocationTrace(this._method, args, this._identifier, this._isOutgoing);
    }

    public String getIdentifier() {
        return this._identifier;
    }

    public LRMIInvocationTrace setIdentifier(String identifier) {
        return new LRMIInvocationTrace(this._method, this._args, identifier, this._isOutgoing);
    }

    public boolean isOutgoing() {
        return this._isOutgoing;
    }

    public String getTraceShortDisplayString() {
        if (this._method == null) {
            return "null method";
        }
        return this._method + " [" + this._identifier + ", " + (this._isOutgoing ? "outgoing" : "incoming") + "]";
    }

    public String getTraceLongDisplayString() {
        if (this._method == null) {
            return "null method";
        }
        return this._method + "(" + (this._args == null ? "null" : Arrays.toString(this._args)) + ") [" + this._identifier + ", " + (this._isOutgoing ? "outgoing" : "incoming") + "]";
    }
}

