/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.filters;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.start.SystemInfo;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;

@InternalApi
public class BouncyCastleSelfSignedCertificate {
    private static final Logger logger = Logger.getLogger(BouncyCastleSelfSignedCertificate.class.getName());
    private static final Provider PROVIDER = new BouncyCastleProvider();
    static final SecureRandom random = new SecureRandom();
    static final Date NOT_BEFORE = new Date(System.currentTimeMillis() - 31536000000L);
    static final Date NOT_AFTER = new Date(253402300799000L);
    private final KeyStore keyStore;
    private static BouncyCastleSelfSignedCertificate instance;
    private static boolean created;

    public static synchronized KeyStore keystore() {
        if (!created) {
            created = true;
            try {
                instance = new BouncyCastleSelfSignedCertificate();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to create self signed certificate", e);
            }
        }
        if (instance != null) {
            return instance.getKeyStore();
        }
        return null;
    }

    private BouncyCastleSelfSignedCertificate() throws Exception {
        this(SystemInfo.singleton().network().getHost().getCanonicalHostName(), random, 1024);
    }

    private BouncyCastleSelfSignedCertificate(String fqdn, SecureRandom random, int bits) throws Exception {
        KeyPair keypair;
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(bits, random);
            keypair = keyGen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        this.keyStore = this.generateKeyStore(fqdn, keypair, random);
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    private KeyStore generateKeyStore(String fqdn, KeyPair keypair, SecureRandom random) throws Exception {
        PrivateKey key = keypair.getPrivate();
        X500Name owner = new X500Name("CN=" + fqdn);
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(owner, new BigInteger(64, random), NOT_BEFORE, NOT_AFTER, owner, keypair.getPublic());
        ContentSigner signer = new JcaContentSignerBuilder("SHA256WithRSAEncryption").build(key);
        X509CertificateHolder certHolder = builder.build(signer);
        X509Certificate cert = new JcaX509CertificateConverter().setProvider(PROVIDER).getCertificate(certHolder);
        cert.verify(keypair.getPublic());
        String keyStoreType = KeyStore.getDefaultType();
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(null, null);
        keyStore.setKeyEntry("key", keypair.getPrivate(), "foo".toCharArray(), new Certificate[]{cert});
        return keyStore;
    }
}

