/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.lrmi.nio.filters;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.start.SystemInfo;
import java.math.BigInteger;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.security.x509.AlgorithmId;
import sun.security.x509.CertificateAlgorithmId;
import sun.security.x509.CertificateIssuerName;
import sun.security.x509.CertificateSerialNumber;
import sun.security.x509.CertificateSubjectName;
import sun.security.x509.CertificateValidity;
import sun.security.x509.CertificateVersion;
import sun.security.x509.CertificateX509Key;
import sun.security.x509.X500Name;
import sun.security.x509.X509CertImpl;
import sun.security.x509.X509CertInfo;

@InternalApi
public class SelfSignedCertificate {
    private static final Logger logger = Logger.getLogger(SelfSignedCertificate.class.getName());
    static final SecureRandom random = new SecureRandom();
    static final Date NOT_BEFORE = new Date(System.currentTimeMillis() - 31536000000L);
    static final Date NOT_AFTER = new Date(253402300799000L);
    private final KeyStore keyStore;
    private static SelfSignedCertificate instance;
    private static boolean created;

    public static synchronized KeyStore keystore() {
        if (!created) {
            created = true;
            try {
                instance = new SelfSignedCertificate();
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to create self signed certificate", e);
            }
        }
        if (instance != null) {
            return instance.getKeyStore();
        }
        return null;
    }

    private SelfSignedCertificate() throws Exception {
        this(SystemInfo.singleton().network().getHost().getCanonicalHostName(), random, 1024);
    }

    private SelfSignedCertificate(String fqdn, SecureRandom random, int bits) throws Exception {
        KeyPair keypair;
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(bits, random);
            keypair = keyGen.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new Error(e);
        }
        this.keyStore = this.generateKeyStore(fqdn, keypair, random);
    }

    public KeyStore getKeyStore() {
        return this.keyStore;
    }

    private KeyStore generateKeyStore(String fqdn, KeyPair keypair, SecureRandom random) throws Exception {
        PrivateKey key = keypair.getPrivate();
        X509CertInfo info = new X509CertInfo();
        X500Name owner = new X500Name("CN=" + fqdn);
        info.set("version", new CertificateVersion(2));
        info.set("serialNumber", new CertificateSerialNumber(new BigInteger(64, random)));
        try {
            info.set("subject", new CertificateSubjectName(owner));
        }
        catch (CertificateException ignore) {
            info.set("subject", owner);
        }
        try {
            info.set("issuer", new CertificateIssuerName(owner));
        }
        catch (CertificateException ignore) {
            info.set("issuer", owner);
        }
        info.set("validity", new CertificateValidity(NOT_BEFORE, NOT_AFTER));
        info.set("key", new CertificateX509Key(keypair.getPublic()));
        info.set("algorithmID", new CertificateAlgorithmId(new AlgorithmId(AlgorithmId.sha1WithRSAEncryption_oid)));
        X509CertImpl cert = new X509CertImpl(info);
        cert.sign(key, "SHA1withRSA");
        info.set("algorithmID.algorithm", cert.get("x509.algorithm"));
        cert = new X509CertImpl(info);
        cert.sign(key, "SHA1withRSA");
        cert.verify(keypair.getPublic());
        String keyStoreType = KeyStore.getDefaultType();
        KeyStore keyStore = KeyStore.getInstance(keyStoreType);
        keyStore.load(null, null);
        keyStore.setKeyEntry("key", keypair.getPrivate(), "foo".toCharArray(), new Certificate[]{cert});
        return keyStore;
    }
}

