/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.start;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.BootIOUtils;
import com.gigaspaces.start.SystemInfo;
import java.io.File;
import java.io.FileFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

@InternalApi
public class ClasspathBuilder {
    private final List<File> files = new ArrayList<File>();

    public ClasspathBuilder appendLib(String path) {
        return this.appendLib(path, null);
    }

    public ClasspathBuilder appendLib(String path, FileFilter filter) {
        return this.append(ClasspathBuilder.path(SystemInfo.singleton().locations().lib(), path), filter);
    }

    public ClasspathBuilder appendRequired() {
        return this.appendRequired(null);
    }

    public ClasspathBuilder appendRequired(FileFilter filter) {
        return this.append(SystemInfo.singleton().locations().getLibRequired(), filter);
    }

    public ClasspathBuilder appendPlatform(String path) {
        return this.append(ClasspathBuilder.path(SystemInfo.singleton().locations().getLibPlatform(), path), null);
    }

    public ClasspathBuilder appendOptional(String path) {
        return this.appendOptional(path, null);
    }

    public ClasspathBuilder appendOptional(String path, FileFilter filter) {
        return this.append(ClasspathBuilder.path(SystemInfo.singleton().locations().getLibOptional(), path), filter);
    }

    public ClasspathBuilder append(String path) {
        return this.append(path, null);
    }

    public ClasspathBuilder append(String path, FileFilter filter) {
        return this.append(path, filter, true);
    }

    public ClasspathBuilder append(String path, FileFilter filter, boolean archivesOnly) {
        filter = archivesOnly ? new JarFileFilter(filter) : filter;
        File f = new File(path);
        if (f.isDirectory()) {
            File[] files;
            for (File file : files = BootIOUtils.listFiles(f, filter)) {
                this.files.add(file);
            }
        } else if (filter == null || filter.accept(f)) {
            this.files.add(f);
        }
        return this;
    }

    public List<URL> toURLs() throws MalformedURLException {
        ArrayList<URL> result = new ArrayList<URL>();
        for (File file : this.files) {
            result.add(file.toURI().toURL());
        }
        return result;
    }

    public URL[] toURLsArray() throws MalformedURLException {
        List<URL> urls = this.toURLs();
        return urls.toArray(new URL[urls.size()]);
    }

    public List<String> toFilesNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (File file : this.files) {
            result.add(file.getAbsolutePath());
        }
        return result;
    }

    private static String path(String base, String subdir) {
        return base + File.separator + subdir;
    }

    public static FileFilter startsWithFilter(final String ... prefix) {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                for (String p : prefix) {
                    if (!file.getName().startsWith(p)) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private static class JarFileFilter
    implements FileFilter {
        private final FileFilter secondaryFilter;

        private JarFileFilter(FileFilter secondaryFilter) {
            this.secondaryFilter = secondaryFilter;
        }

        @Override
        public boolean accept(File pathname) {
            String filename = pathname.getName().toLowerCase();
            if (filename.endsWith(".jar") || filename.endsWith(".zip")) {
                return this.secondaryFilter != null ? this.secondaryFilter.accept(pathname) : true;
            }
            return false;
        }
    }
}

