/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.start;

import com.gigaspaces.api.InternalApi;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

@InternalApi
public class ConfigurationParser {
    private DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private DocumentBuilder builder = null;
    static Logger logger = Logger.getLogger("com.gigaspaces.start");

    public ConfigurationParser() throws ParserConfigurationException {
        this(false, Thread.currentThread().getContextClassLoader());
    }

    public ConfigurationParser(ClassLoader loader) throws ParserConfigurationException {
        this(false, loader);
    }

    public ConfigurationParser(boolean verify, ClassLoader loader) throws ParserConfigurationException {
        this.factory.setValidating(verify);
        this.factory.setNamespaceAware(true);
        this.factory.setExpandEntityReferences(true);
        this.factory.setCoalescing(true);
        this.builder = this.factory.newDocumentBuilder();
        if (verify) {
            this.builder.setErrorHandler(new XMLErrorHandler());
        }
        if (loader == null) {
            throw new NullPointerException("loader is null");
        }
    }

    public String[] parseConfiguration(File xmlFile) throws SAXException, IOException {
        Document document = this.builder.parse(xmlFile);
        return this.parseConfiguration(document);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] parseConfiguration(URL xmlURL) throws IOException, SAXException {
        Document document = null;
        try (InputStream is = xmlURL.openStream();){
            document = this.builder.parse(is);
        }
        return this.parseConfiguration(document);
    }

    public String[] parseConfiguration(String xmlLocation) throws IOException, SAXException {
        URL fileURL = null;
        fileURL = xmlLocation.startsWith("http") || xmlLocation.startsWith("file:") ? new URL(xmlLocation) : new File(xmlLocation).toURI().toURL();
        if (fileURL == null) {
            throw new FileNotFoundException("XML Location [" + xmlLocation + "] not found");
        }
        return this.parseConfiguration(fileURL);
    }

    public String[] parseConfiguration(Document document) {
        NodeList nList = document.getElementsByTagName("Configuration");
        if (nList.getLength() == 0) {
            nList = document.getElementsByTagName("configuration");
        }
        if (nList.getLength() == 0) {
            nList = document.getElementsByTagName("Overrides");
        }
        if (nList.getLength() == 0) {
            nList = document.getElementsByTagName("overrides");
        }
        ArrayList configList = new ArrayList();
        for (int i = 0; i < nList.getLength(); ++i) {
            Element element = (Element)nList.item(i);
            configList.addAll(ConfigurationParser.parseConfiguration(element));
        }
        return configList.toArray(new String[configList.size()]);
    }

    public static List parseConfiguration(Element element) {
        String componentName = null;
        ArrayList<String> configList = new ArrayList<String>();
        NodeList nList = element.getChildNodes();
        for (int i = 0; i < nList.getLength(); ++i) {
            Element el;
            Node node = nList.item(i);
            if (node.getNodeType() != 1 || !(el = (Element)node).getTagName().equalsIgnoreCase("component")) continue;
            NamedNodeMap nm = nList.item(i).getAttributes();
            Node node1 = nm.getNamedItem("Name");
            if (node1 == null) {
                node1 = nm.getNamedItem("name");
            }
            if (!(componentName = node1.getNodeValue()).endsWith(".")) {
                componentName = componentName + ".";
            }
            componentName = componentName.replace(' ', '_');
            Properties parms = ConfigurationParser.parseParameters(el);
            for (Map.Entry me : parms.entrySet()) {
                String name = (String)me.getKey();
                String value = (String)me.getValue();
                configList.add(componentName + name + "=" + value);
            }
        }
        return configList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static Properties parseParameters(Element element) {
        Properties props = new Properties();
        String name = null;
        String value = null;
        NodeList nList = element.getElementsByTagName("Parameter");
        if (nList.getLength() == 0) {
            nList = element.getElementsByTagName("parameter");
        }
        for (int i = 0; i < nList.getLength(); ++i) {
            Element parameterElement = (Element)nList.item(i);
            NamedNodeMap nm = parameterElement.getAttributes();
            Node node = nm.getNamedItem("Name");
            if (node == null) {
                node = nm.getNamedItem("name");
            }
            name = node.getNodeValue();
            String elementValue = ConfigurationParser.getTextValue(parameterElement);
            node = nm.getNamedItem("Value");
            if (node == null) {
                node = nm.getNamedItem("value");
            }
            if (elementValue.length() > 0 && node != null) {
                throw new IllegalArgumentException("Declare either a Value attribute or a <Parameter> value, not both");
            }
            if (node == null) {
                if (elementValue.length() <= 0) throw new IllegalArgumentException("You must declare a Value attribute or a <Parameter> value");
                value = elementValue;
            } else {
                value = node.getNodeValue();
            }
            props.put(name, value);
        }
        if (!logger.isLoggable(Level.FINEST)) return props;
        String tagName = element.getTagName();
        if (element.getParentNode() != null && element.getParentNode() instanceof Element) {
            tagName = ((Element)element.getParentNode()).getTagName() + "." + tagName;
        }
        logger.finest("Element [" + tagName + "], Parameters: " + props.toString());
        return props;
    }

    public static String getTextValue(Node node) {
        NodeList eList = node.getChildNodes();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < eList.getLength(); ++i) {
            Node n = eList.item(i);
            if (n.getNodeType() == 5) {
                sb.append(ConfigurationParser.getTextValue(n));
                continue;
            }
            if (n.getNodeType() != 3) continue;
            sb.append(n.getNodeValue());
        }
        return sb.toString().trim();
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("A proper invocation includes passing at least one argument, of which should be an xml file");
            System.exit(1);
        }
        try {
            ConfigurationParser cp = new ConfigurationParser();
            String[] result = cp.parseConfiguration(args[0]);
            for (int i = 0; i < result.length; ++i) {
                System.out.println(result[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class XMLErrorHandler
    implements ErrorHandler {
        XMLErrorHandler() {
        }

        @Override
        public void warning(SAXParseException err) throws SAXException {
            System.out.println("+++ Warning, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            System.out.println("   " + err.getMessage());
        }

        @Override
        public void error(SAXParseException err) throws SAXException {
            System.out.println("+++ Error, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            System.out.println("   " + err.getMessage());
            throw err;
        }

        @Override
        public void fatalError(SAXParseException err) throws SAXException {
            System.out.println("+++ Fatal, line " + err.getLineNumber() + ", uri " + err.getSystemId());
            System.out.println("   " + err.getMessage());
            throw err;
        }
    }
}

