/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.start;

import com.gigaspaces.internal.io.BootIOUtils;
import com.gigaspaces.internal.jvm.JavaUtils;
import com.gigaspaces.start.JavaCommandBuilder;
import com.gigaspaces.start.SystemInfo;
import java.io.File;
import java.util.Optional;

public class GsCommandFactory {
    protected final JavaCommandBuilder command = new JavaCommandBuilder();

    public static void main(String[] args) {
        GsCommandFactory.execute(args, new GsCommandFactory());
    }

    protected static void execute(String[] args, GsCommandFactory builder) {
        try {
            String s = builder.generate(args[0]).toCommandLine();
            System.out.println(s);
            System.exit(0);
        }
        catch (Throwable e) {
            System.out.println("Error: " + e);
            System.exit(1);
        }
    }

    protected JavaCommandBuilder generate(String id) {
        switch (id.toLowerCase()) {
            case "cli": {
                return this.cli();
            }
        }
        return this.custom(id);
    }

    private JavaCommandBuilder custom(String mainClass) {
        this.command.mainClass(mainClass);
        this.appendGsClasspath();
        this.appendSpringClassPath();
        this.appendXapOptions();
        return this.command;
    }

    protected JavaCommandBuilder cli() {
        this.command.mainClass("org.gigaspaces.cli.commands.XapMainCommand");
        this.command.classpathFromPath(SystemInfo.singleton().getXapHome(), "tools", "cli", "*");
        this.command.classpathFromPath(SystemInfo.singleton().locations().getLibPlatform(), "blueprints", "*");
        this.appendGsClasspath();
        this.appendXapOptions();
        return this.command;
    }

    public JavaCommandBuilder lus() {
        this.command.mainClass("com.gigaspaces.internal.lookup.LookupServiceFactory");
        this.appendXapOptions();
        this.command.optionsFromEnv("XAP_LUS_OPTIONS");
        this.command.classpath(SystemInfo.singleton().getXapHome());
        this.appendGsClasspath();
        this.command.classpathFromPath(this.locations().getLibPlatform(), "service-grid", "*");
        this.command.classpathFromPath(this.locations().getLibPlatform(), "logger", "*");
        this.command.classpathFromPath(this.locations().getLibPlatform(), "zookeeper", "*");
        return this.command;
    }

    public JavaCommandBuilder standalonePuInstance() {
        this.command.mainClass("org.openspaces.pu.container.standalone.StandaloneProcessingUnitContainer");
        this.appendXapOptions();
        this.preClasspath();
        this.appendGsClasspath();
        this.command.classpathFromPath(this.locations().getLibPlatform(), "service-grid", "*");
        this.command.classpathFromPath(this.locations().getLibPlatform(), "logger", "*");
        this.command.classpathFromPath(this.locations().getLibPlatform(), "zookeeper", "*");
        this.appendSpringClassPath();
        this.postClasspath();
        return this.command;
    }

    public JavaCommandBuilder spaceInstance() {
        this.command.mainClass("org.openspaces.pu.container.integrated.IntegratedProcessingUnitContainer");
        this.appendXapOptions();
        this.command.optionsFromEnv("XAP_SPACE_INSTANCE_OPTIONS");
        this.preClasspath();
        this.command.classpathFromPath(this.locations().deploy(), "templates", "datagrid");
        this.appendGsClasspath();
        this.command.classpathFromPath(this.locations().getLibPlatform(), "service-grid", "*");
        this.command.classpathFromPath(this.locations().getLibPlatform(), "logger", "*");
        this.command.classpathFromPath(this.locations().getLibPlatform(), "zookeeper", "*");
        this.postClasspath();
        return this.command;
    }

    protected SystemInfo.XapLocations locations() {
        return SystemInfo.singleton().locations();
    }

    protected void preClasspath() {
        this.command.classpathFromEnv("PRE_CLASSPATH");
    }

    protected void postClasspath() {
        this.command.classpathFromEnv("POST_CLASSPATH");
    }

    protected void appendSpringClassPath() {
        this.command.classpathFromPath(this.locations().getLibOptional(), "spring", "*");
        this.command.classpathFromPath(this.locations().getLibOptional(), "security", "*");
    }

    protected void appendSigarClassPath() {
        this.command.classpathFromPath(this.locations().getLibOptional(), "sigar", "*");
    }

    protected void addOshiAndLoggerToClasspath() {
        this.command.classpathFromPath(this.locations().getLibOptional(), "oshi", "*");
        this.command.classpathFromPath(this.locations().getLibPlatform(), "logger", "*");
    }

    protected void appendXapOptions() {
        if (GsCommandFactory.getSystemEnv("XAP_OPTIONS").isPresent()) {
            this.command.optionsFromEnv("XAP_OPTIONS");
        } else {
            String vendor = JavaUtils.getVendor().toUpperCase();
            if (vendor.startsWith("ORACLE ")) {
                this.command.option("-server");
                if (!JavaUtils.greaterOrEquals(11)) {
                    this.command.option("-XX:+AggressiveOpts");
                }
                this.command.option("-XX:+HeapDumpOnOutOfMemoryError");
            } else if (vendor.startsWith("IBM ")) {
                this.command.option("-XX:MaxPermSize=256m");
            }
            if (JavaUtils.greaterOrEquals(9)) {
                this.command.option("--add-opens=jdk.management/com.sun.management.internal=ALL-UNNAMED");
                this.command.option("--add-modules=ALL-SYSTEM");
            }
            this.command.systemProperty("com.gs.home", BootIOUtils.quoteIfContainsSpace(SystemInfo.singleton().getXapHome()));
            this.command.systemProperty("java.util.logging.config.file", BootIOUtils.quoteIfContainsSpace(GsCommandFactory.getSystemEnv("XAP_LOGS_CONFIG_FILE").orElseGet(this::defaultConfigPath)));
            this.command.systemProperty("java.rmi.server.hostname", System.getenv("XAP_NIC_ADDRESS"));
            this.command.optionsFromEnv("EXT_JAVA_OPTIONS");
            this.command.optionsFromEnv("XAP_OPTIONS_EXT");
        }
    }

    protected void appendGsClasspath() {
        this.command.classpathFromPath(this.locations().getLibPlatform(), "ext", "*");
        this.command.classpathFromPath(SystemInfo.singleton().getXapHome());
        this.command.classpathFromPath(this.locations().getLibRequired(), "*");
        this.command.classpathFromPath(this.locations().getLibOptional(), "pu-common", "*");
        this.command.classpathFromEnv("XAP_CLASSPATH_EXT");
    }

    private String defaultConfigPath() {
        return this.locations().config() + File.separator + "log" + File.separator + "xap_logging.properties";
    }

    protected static Optional<String> getSystemEnv(String name) {
        String val = System.getenv(name);
        return val != null ? Optional.of(val) : Optional.empty();
    }
}

