/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.start;

import com.gigaspaces.internal.io.BootIOUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class JavaCommandBuilder {
    private final Map<String, String> env = System.getenv();
    private String javaExecutable;
    private final Map<String, String> systemProperties = new LinkedHashMap<String, String>();
    private final Collection<String> options = new LinkedHashSet<String>();
    private String mainClass;
    private final Collection<String> arguments = new LinkedHashSet<String>();
    private final Collection<String> classpath = new LinkedHashSet<String>();

    public List<String> build() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(!JavaCommandBuilder.isEmpty(this.javaExecutable) ? this.javaExecutable : this.getDefaultJavaExecutable());
        this.systemProperties.forEach((k, v) -> command.add("-D" + k + "=" + v));
        command.addAll(this.options);
        command.add("-classpath");
        command.add(String.join((CharSequence)File.pathSeparator, this.classpath));
        command.add(this.mainClass);
        command.addAll(this.arguments);
        return command;
    }

    public ProcessBuilder toProcessBuilder() {
        return new ProcessBuilder(this.build());
    }

    public String toCommandLine() {
        return String.join((CharSequence)" ", this.build());
    }

    public JavaCommandBuilder javaExecutable(String javaExecutable) {
        this.javaExecutable = javaExecutable;
        return this;
    }

    public JavaCommandBuilder mainClass(String mainClass) {
        this.mainClass = mainClass;
        return this;
    }

    public JavaCommandBuilder classpath(String classpath) {
        if (!JavaCommandBuilder.isEmpty(classpath)) {
            this.classpath.add(BootIOUtils.quoteIfContainsSpace(classpath));
        }
        return this;
    }

    public JavaCommandBuilder classpathFromPath(String ... elements) {
        return this.classpath(String.join((CharSequence)File.separator, elements));
    }

    public JavaCommandBuilder classpathFromEnv(String envVarName) {
        return this.classpath(this.env.get(envVarName));
    }

    public JavaCommandBuilder classpathFromEnv(String envVarName, Runnable defaultProvider) {
        if (this.env.containsKey(envVarName)) {
            this.classpath(this.env.get(envVarName));
        } else if (defaultProvider != null) {
            defaultProvider.run();
        }
        return this;
    }

    public JavaCommandBuilder systemProperty(String key, String value) {
        this.systemProperties.put(key, value);
        return this;
    }

    public JavaCommandBuilder option(String option) {
        if (!JavaCommandBuilder.isEmpty(option)) {
            this.options.add(option);
        }
        return this;
    }

    public JavaCommandBuilder options(Collection<String> options) {
        this.options.addAll(options);
        return this;
    }

    public JavaCommandBuilder optionsFromEnv(String envVarName) {
        String s = this.env.get(envVarName);
        if (!JavaCommandBuilder.isEmpty(s)) {
            for (String option : s.split(" ")) {
                this.option(option);
            }
        }
        return this;
    }

    public JavaCommandBuilder systemPropertyFromEnv(String key, String envVarName) {
        String s = this.env.get(envVarName);
        if (!JavaCommandBuilder.isEmpty(s)) {
            this.systemProperty(key, s);
        }
        return this;
    }

    public JavaCommandBuilder heap(String heap) {
        this.initialHeap(heap);
        this.maxHeap(heap);
        return this;
    }

    public JavaCommandBuilder initialHeap(String heap) {
        if (!JavaCommandBuilder.isEmpty(heap)) {
            this.options.add("-Xms" + heap);
        }
        return this;
    }

    public JavaCommandBuilder maxHeap(String heap) {
        if (!JavaCommandBuilder.isEmpty(heap)) {
            this.options.add("-Xmx" + heap);
        }
        return this;
    }

    public JavaCommandBuilder arg(String arg) {
        if (!JavaCommandBuilder.isEmpty(arg)) {
            this.arguments.add(arg);
        }
        return this;
    }

    private String getDefaultJavaExecutable() {
        String command = this.env.get("JAVACMD");
        if (command == null) {
            String javaHome = this.env.get("JAVA_HOME");
            if (javaHome == null) {
                javaHome = this.env.get("XapNet.Runtime.JavaHome");
            }
            if (javaHome != null) {
                command = javaHome + File.separator + "bin" + File.separator + "java";
            }
        }
        if (command == null) {
            command = "java";
        }
        return command;
    }

    public String getDefaultJavaWindowsExecutable() {
        String command = this.env.get("JAVAWCMD");
        if (command == null) {
            String javaHome = this.env.get("JAVA_HOME");
            if (javaHome == null) {
                javaHome = this.env.get("XapNet.Runtime.JavaHome");
            }
            if (javaHome != null) {
                command = javaHome + File.separator + "bin" + File.separator + "javaw";
            }
        }
        if (command == null) {
            command = "javaw";
        }
        return command;
    }

    private static boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }
}

