/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.start;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.BootIOUtils;
import com.gigaspaces.logger.LogHelper;
import com.gigaspaces.start.XapModules;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.CodeSource;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

@InternalApi
public class Locator {
    public static final String GS_HOME_DIR_SYSTEM_PROP = "com.gs.home.dir";
    static final String COMPONENT = "com.gigaspaces.start";
    public static final String GS_HOME = "com.gs.home";
    private static final String GS_LIB = "com.gigaspaces.lib";
    public static final String GS_BOOT_LIB = "com.gigaspaces.lib.boot";
    private static final String GS_LIB_REQUIRED = "com.gigaspaces.lib.required";
    private static final String GS_LIB_PLATFORM = "com.gigaspaces.lib.platform";
    private static final String GS_LIB_OPTIONAL = "com.gigaspaces.lib.opt";
    public static final String GS_LIB_PLATFORM_EXT = "com.gigaspaces.lib.platform.ext";
    public static final String GS_LIB_OPTIONAL_SECURITY = "com.gigaspaces.lib.opt.security";

    public static String getLib(Properties properties) {
        return Locator.getLocation(properties, GS_LIB);
    }

    public static String getLibRequired() {
        return System.getProperty(GS_LIB_REQUIRED);
    }

    public static String getLibRequired(Properties properties) {
        return Locator.getLocation(properties, GS_LIB_REQUIRED);
    }

    public static String getLibPlatform() {
        return System.getProperty(GS_LIB_PLATFORM);
    }

    public static String getLibPlatform(Properties properties) {
        return Locator.getLocation(properties, GS_LIB_PLATFORM);
    }

    public static String getLibOptional() {
        return System.getProperty(GS_LIB_OPTIONAL);
    }

    public static String getLib() {
        return System.getProperty(GS_LIB);
    }

    public static String getLibOptional(Properties properties) {
        return Locator.getLocation(properties, GS_LIB_OPTIONAL);
    }

    public static String getLibOptionalSecurity() {
        return System.getProperty(GS_LIB_OPTIONAL_SECURITY, Locator.getLibOptional() + "security");
    }

    public static String getLocation(Properties properties, String key) {
        String value = properties.getProperty(key);
        if (value != null) {
            System.setProperty(key, value);
        }
        return value;
    }

    public static Properties deriveDirectories() {
        Properties locationProps = new Properties();
        if (System.getProperty(GS_HOME_DIR_SYSTEM_PROP) != null) {
            String path = System.getProperty(GS_HOME_DIR_SYSTEM_PROP) + File.separator;
            locationProps.put(GS_HOME, path);
            locationProps.put(GS_LIB, path);
            locationProps.put(GS_BOOT_LIB, path);
            return locationProps;
        }
        try {
            String path = Locator.getClassLocation(Locator.class);
            if (path == null) {
                String workDir = Locator.path(System.getProperty("user.dir"), "gigaspaces");
                LogHelper.log(COMPONENT, Level.FINE, "Setting Home to [" + workDir + "] since can't derive location from jar file", null);
                new File(workDir).mkdirs();
                locationProps.put(GS_HOME, workDir);
                locationProps.put(GS_LIB, workDir);
                locationProps.put(GS_BOOT_LIB, workDir);
            } else {
                File location = Locator.getLocation(path);
                File gsLib = Locator.findGsLib(path, location);
                locationProps.setProperty(GS_HOME, new File(gsLib, "..").getCanonicalPath() + File.separator);
                locationProps.setProperty(GS_LIB, gsLib.getCanonicalPath() + File.separator);
                locationProps.setProperty(GS_BOOT_LIB, location.getCanonicalPath() + File.separator);
                Locator.initDefaultLocations(locationProps, gsLib);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to derive product directories", e);
        }
        LogHelper.log(COMPONENT, Level.FINE, "Derived product directories " + locationProps, null);
        return locationProps;
    }

    private static File getLocation(String path) {
        int ndx = path.lastIndexOf("/");
        if (ndx != -1) {
            path = Locator.checkDirFormat(path.substring(0, ndx));
        }
        return new File(path);
    }

    private static void initDefaultLocations(Properties properties, File gsLib) throws IOException {
        properties.setProperty(GS_LIB, gsLib.getCanonicalPath() + File.separator);
        properties.setProperty(GS_LIB_REQUIRED, new File(gsLib, "required").getCanonicalPath() + File.separator);
        properties.setProperty(GS_LIB_PLATFORM, new File(gsLib, "platform").getCanonicalPath() + File.separator);
        properties.setProperty(GS_LIB_OPTIONAL, new File(gsLib, "optional").getCanonicalPath() + File.separator);
    }

    public static String derivePath(String fileName) {
        Properties props = Locator.deriveDirectories();
        String baseDir = (String)props.get(GS_HOME);
        Logger logger = Logger.getLogger(COMPONENT);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Derive path for file: " + fileName + " | locations: " + props.toString());
        }
        return Locator.derivePath(baseDir, fileName);
    }

    public static String derivePath(String baseDir, String fileName) {
        File checkDir;
        String sysProp;
        Logger logger = Logger.getLogger(COMPONENT);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Derive path for file: " + fileName + " | baseDir: " + baseDir);
        }
        if (baseDir == null) {
            throw new NullPointerException("baseDir is null");
        }
        if (fileName == null) {
            throw new NullPointerException("fileName is null");
        }
        if (baseDir.startsWith("$") && (baseDir = System.getProperty(sysProp = baseDir.substring(1))) == null) {
            throw new IllegalArgumentException("baseDir [" + sysProp + "] does not reference a valid System Property");
        }
        File base = new File(baseDir);
        if (!base.exists()) {
            throw new IllegalArgumentException(baseDir + " does not exist");
        }
        if (!base.isDirectory()) {
            throw new IllegalArgumentException(baseDir + " is not a directory");
        }
        if (!base.canRead()) {
            throw new IllegalArgumentException("cannot read from " + baseDir);
        }
        String path = Locator.locate(base, fileName);
        if (path != null && (checkDir = new File(path)).isDirectory()) {
            path = Locator.checkDirFormat(path);
        }
        return path;
    }

    private static String checkDirFormat(String dir) {
        if (dir == null) {
            throw new NullPointerException("dir is null");
        }
        File directory = new File(dir);
        if (!directory.exists()) {
            throw new IllegalArgumentException("directory [" + dir + "] does not exist");
        }
        if (!directory.canRead()) {
            throw new IllegalArgumentException("no read access to directory [" + dir + "]");
        }
        if (!dir.endsWith(File.separator)) {
            dir = dir + File.separator;
        }
        return dir;
    }

    private static String locate(File baseDir, String fileName) {
        if (baseDir == null) {
            throw new IllegalArgumentException("baseDir is null");
        }
        if (fileName == null) {
            throw new IllegalArgumentException("subDirName is null");
        }
        String foundFile = null;
        File[] files = BootIOUtils.listFiles(baseDir);
        ArrayList<File> dirList = new ArrayList<File>();
        for (File file1 : files) {
            if (file1.getName().equals(fileName)) {
                try {
                    foundFile = file1.getCanonicalPath();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                break;
            }
            if (!file1.isDirectory() || !file1.canRead()) continue;
            dirList.add(file1);
        }
        if (foundFile == null) {
            File[] dirs;
            for (File dir : dirs = dirList.toArray(new File[dirList.size()])) {
                String file = Locator.locate(dir, fileName);
                if (file == null) continue;
                foundFile = file;
                break;
            }
        }
        return foundFile;
    }

    public static String getProductHomeDirectoryName() {
        return Locator.path(System.getProperty("user.home"), ".gigaspaces");
    }

    private static String path(String path, String element) {
        return path + File.separator + element;
    }

    private static String path(String path, String ... elements) {
        for (String element : elements) {
            path = Locator.path(path, element);
        }
        return path;
    }

    private static String getClassLocation(Class<?> clazz) throws URISyntaxException {
        CodeSource cs = clazz.getProtectionDomain().getCodeSource();
        return cs != null && cs.getLocation() != null ? cs.getLocation().toURI().getPath() : null;
    }

    private static File findGsLib(String path, File location) {
        if (path.contains("platform/ui/xap-ui.jar")) {
            return new File(new File(location, ".."), "..");
        }
        if (path.contains("lib" + XapModules.DATA_GRID.getJarFilePath())) {
            return new File(location, "..");
        }
        if (path.contains("lib" + XapModules.CORE_COMMON.getJarFilePath())) {
            return new File(location, "..");
        }
        return new File(location, "..");
    }
}

