/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.start;

import com.gigaspaces.api.BootException;
import com.gigaspaces.api.InternalApi;
import com.gigaspaces.grid.gsa.AgentHelper;
import com.gigaspaces.internal.jvm.JVMHelper;
import com.gigaspaces.internal.jvm.JVMStatistics;
import com.gigaspaces.internal.sigar.SigarChecker;
import com.gigaspaces.logger.GSLogConfigLoader;
import com.gigaspaces.logger.RollingFileHandler;
import com.gigaspaces.start.SystemConfig;
import com.gigaspaces.start.SystemInfo;
import com.sun.jini.start.ServiceDescriptor;
import java.beans.Introspector;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.lang.annotation.Annotation;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.reflect.Field;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import org.jini.rio.boot.BootUtil;
import org.jini.rio.boot.CommonClassLoader;

@InternalApi
public class SystemBoot {
    public static final String LH = "LH";
    public static final String TM = "TM";
    public static final String NO_JMX = "NO_JMX";
    public static final String GSC = "GSC";
    public static final String GSA = "GSA";
    public static final String GSM = "GSM";
    public static final String ESM = "ESM";
    public static final String SPACE = "GS";
    static final String COMPONENT = "com.gigaspaces.start";
    private static Logger logger;
    static final String SERVICES_COMPONENT = "com.gigaspaces.start.services";
    static final List<Thread> shutdownHooks;
    private static volatile boolean runningWithinGSC;
    private static ControllablePrintStream outStream;
    private static ControllablePrintStream errStream;
    private static String processRole;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addShutdownHook(Thread shutdownHook) {
        List<Thread> list = shutdownHooks;
        synchronized (list) {
            shutdownHooks.add(shutdownHook);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeShutdownHook(Thread shutdownHook) {
        List<Thread> list = shutdownHooks;
        synchronized (list) {
            shutdownHooks.remove(shutdownHook);
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
    }

    public static boolean isRunningWithinGSC() {
        return runningWithinGSC;
    }

    public static void iAmTheGSC() {
        runningWithinGSC = true;
    }

    public static int getRegistryPort() {
        int registryPort;
        block3: {
            registryPort = 0;
            String sPort = System.getProperty("com.gigaspaces.system.registryPort");
            if (sPort != null) {
                try {
                    registryPort = Integer.parseInt(sPort);
                }
                catch (NumberFormatException e) {
                    if (!logger.isLoggable(Level.FINE)) break block3;
                    logger.finest("Bad value for RMI Registry Port [" + sPort + "]");
                }
            }
        }
        return registryPort;
    }

    public static String getJMXServiceURL() {
        return System.getProperty("com.gigaspaces.system.jmxServiceURL");
    }

    public static void loadPlatform() throws ConfigurationException, IOException {
        SystemConfig sysConfig = SystemConfig.getInstance();
        Properties addSysProps = sysConfig.getSystemProperties();
        URL[] platformJARs = sysConfig.getPlatformJars();
        if (platformJARs.length == 0) {
            throw new RuntimeException("No platformJARs have been defined");
        }
        CommonClassLoader commonCL = CommonClassLoader.getInstance();
        commonCL.addCommonJARs(platformJARs);
        addSysProps = sysConfig.getSystemProperties();
        if (logger.isLoggable(Level.FINE)) {
            StringBuilder buff = new StringBuilder();
            Enumeration<?> en = addSysProps.propertyNames();
            while (en.hasMoreElements()) {
                String name = (String)en.nextElement();
                String value = addSysProps.getProperty(name);
                buff.append("    ").append(name).append("=").append(value);
                buff.append("\n");
            }
            logger.fine("Configured System Properties {\n" + buff.toString() + "}");
        }
        Properties sysProps = System.getProperties();
        sysProps.putAll((Map<?, ?>)addSysProps);
        System.setProperties(sysProps);
        logger.finest("Full list of System Properties {\n" + System.getProperties() + "}");
    }

    private static Set<String> toSet(String s) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        StringTokenizer tok = new StringTokenizer(s, " ,");
        while (tok.hasMoreTokens()) {
            result.add(tok.nextToken());
        }
        return result;
    }

    public static void main(String[] args) {
        outStream = new ControllablePrintStream(System.out);
        System.setOut(outStream);
        errStream = new ControllablePrintStream(System.err);
        System.setErr(errStream);
        Introspector.flushCaches();
        RollingFileHandler.monitorCreatedFiles();
        try {
            String command = BootUtil.arrayToDelimitedString(args, " ");
            boolean isSilent = SystemBoot.isSilent(command);
            SystemBoot.preProcess(args);
            processRole = SystemBoot.getLogFileName(args);
            logger = SystemBoot.getLogger(processRole);
            if (!isSilent) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("Starting ServiceGrid [user=" + System.getProperty("user.name") + ", command=\"" + command + "\"]");
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("Security policy=" + System.getProperty("java.security.policy"));
                }
            }
            SigarChecker.isAvailable();
            if (AgentHelper.hasAgentId()) {
                System.out.println("pid=" + SystemInfo.singleton().os().processId());
            }
            SystemBoot.prepareRmiGC();
            SystemConfig systemConfig = SystemConfig.getInstance(args);
            Configuration config = systemConfig.getConfiguration();
            SystemBoot.loadPlatform();
            Set<String> services = SystemBoot.toSet((String)config.getEntry(COMPONENT, "services", String.class, GSC));
            if (!isSilent) {
                SystemBoot.initJmxIfNeeded(services, systemConfig, config);
            }
            SystemBoot.enableDynamicLocatorsIfNeeded();
            final ArrayList<Closeable> customServices = new ArrayList<Closeable>();
            for (String service : services) {
                ServiceDescriptor serviceDescriptor = systemConfig.getServiceDescriptor(service);
                if (logger.isLoggable(Level.CONFIG)) {
                    logger.log(Level.CONFIG, "Creating service " + service + (serviceDescriptor == null ? "" : " with serviceDescriptor " + serviceDescriptor));
                }
                if (serviceDescriptor != null) {
                    serviceDescriptor.create(config);
                    continue;
                }
                Closeable customService = systemConfig.getCustomService(service);
                if (customService == null) continue;
                customServices.add(customService);
            }
            final Thread scheduledSystemBootThread = SystemBoot.createScheduledSystemBootThread();
            scheduledSystemBootThread.start();
            final Thread mainThread = Thread.currentThread();
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    for (Closeable customService : customServices) {
                        try {
                            customService.close();
                        }
                        catch (IOException e) {
                            if (!logger.isLoggable(Level.WARNING)) continue;
                            logger.log(Level.WARNING, "Failed to close service " + customService.toString(), e);
                        }
                    }
                    scheduledSystemBootThread.interrupt();
                    mainThread.interrupt();
                }
            });
            if (AgentHelper.hasAgentId()) {
                SystemBoot.mainAgent(mainThread, systemConfig);
            } else {
                while (!mainThread.isInterrupted()) {
                    try {
                        Thread.sleep(Long.MAX_VALUE);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
        catch (Throwable t) {
            Throwable bootException = SystemBoot.getCauseByAnnotation(t, BootException.class);
            if (bootException != null) {
                SystemBoot.reportError(bootException, true);
            } else {
                SystemBoot.reportError(t, false);
            }
            System.exit(1);
        }
    }

    private static void reportError(Throwable t, boolean bootError) {
        if (logger != null) {
            if (bootError) {
                logger.log(Level.SEVERE, "Error while booting system - " + t.getMessage());
            } else {
                logger.log(Level.SEVERE, "Error while booting system - ", t);
            }
        } else if (bootError) {
            System.err.println("Error while booting system - " + t.getMessage());
        } else {
            System.err.println("Error while booting system - " + t);
            t.printStackTrace();
        }
    }

    private static Throwable getCauseByAnnotation(Throwable root, Class<? extends Annotation> annotationClass) {
        for (Throwable e = root; e != null; e = e.getCause()) {
            if (e.getClass().getAnnotation(annotationClass) == null) continue;
            return e;
        }
        return null;
    }

    private static boolean isSilent(String command) {
        return command.equals("services=GSA -h") || command.startsWith("services=GSA --help");
    }

    private static void mainAgent(Thread mainThread, SystemConfig systemConfig) throws InterruptedException {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        });
        SystemBoot.waitForStopCommand(mainThread, systemConfig);
        logger.info("Received stop command from GSA, exiting");
        outStream.ignore = true;
        errStream.ignore = true;
        StringBuilder sb = SystemBoot.processShutdownHooks();
        outStream.ignore = false;
        errStream.ignore = false;
        System.out.println("Exiting... \n" + sb);
        System.out.println("gsa-exit-done");
        System.out.flush();
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuilder processShutdownHooks() {
        StringBuilder sb = new StringBuilder();
        ExecutorService singleThreadExecutor = Executors.newSingleThreadExecutor();
        sb.append("Started shutdown at: ").append(new Date()).append("\n");
        List<Thread> list = shutdownHooks;
        synchronized (list) {
            sb.append("Calling [").append(shutdownHooks.size()).append("] ShutdownHooks...").append("\n");
            for (Thread shutdownHook : shutdownHooks) {
                Future<?> future = null;
                try {
                    sb.append("> ShutdownHook called for: ").append(shutdownHook.getName()).append("\n");
                    future = singleThreadExecutor.submit(shutdownHook);
                    future.get(10L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    if (future != null) {
                        future.cancel(true);
                    }
                    sb.append("> ShutdownHook.run() reported exception: ").append(e).append("\n").append(BootUtil.getStackTrace(e)).append("\n");
                }
            }
            shutdownHooks.clear();
        }
        singleThreadExecutor.shutdownNow();
        sb.append("Completed shutdown at: ").append(new Date()).append("\n");
        return sb;
    }

    private static void waitForStopCommand(Thread mainThread, SystemConfig systemConfig) throws InterruptedException {
        while (!mainThread.isInterrupted()) {
            File workLocation = new File(System.getProperty("com.gs.work", systemConfig.getHomeDir() + "/work"));
            File file = new File(workLocation, "/gsa/gsa-" + AgentHelper.getGSAServiceID() + "-" + AgentHelper.getAgentId() + "-stop");
            if (file.exists()) {
                file.deleteOnExit();
                for (int i = 0; i < 5 && !file.delete(); ++i) {
                    Thread.sleep(5L);
                }
                break;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                break;
            }
        }
    }

    private static Thread createScheduledSystemBootThread() {
        final long scheduledSystemBootTime = Long.parseLong(System.getProperty("gs.start.scheduledSystemBootTime", "10000"));
        final boolean loadCleanerEnabled = System.getProperty("gs.rmi.loaderHandlerCleaner", "true").equals("true");
        final long gcCollectionWarning = Long.parseLong(System.getProperty("gs.gc.collectionTimeThresholdWarning", "60000"));
        logger.fine("GC collection time warning set to [" + gcCollectionWarning + "ms]");
        Thread scheduledSystemBootThread = new Thread("GS-Scheduled-System-Boot-Thread"){

            @Override
            public void run() {
                RmiLoaderHandlerCleaner loaderHandlerCleaner = new RmiLoaderHandlerCleaner();
                JVMStatistics jvmStats = JVMHelper.getStatistics();
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        Thread.sleep(scheduledSystemBootTime);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    JVMStatistics newStats = JVMHelper.getStatistics();
                    long collectionTime = newStats.getGcCollectionTime() - jvmStats.getGcCollectionTime();
                    if (collectionTime > gcCollectionWarning) {
                        logger.warning("Long GC collection occurred, took [" + collectionTime + "ms], breached threshold [" + gcCollectionWarning + "]");
                    }
                    jvmStats = newStats;
                    if (loadCleanerEnabled) {
                        loaderHandlerCleaner.clean();
                    }
                    SystemBoot.exitIfHasAgentAndAgentIsNotRunning();
                }
            }
        };
        scheduledSystemBootThread.setDaemon(true);
        return scheduledSystemBootThread;
    }

    private static void enableDynamicLocatorsIfNeeded() {
        if (AgentHelper.hasAgentId() && AgentHelper.enableDynamicLocators()) {
            if (logger.isLoggable(Level.INFO)) {
                logger.info("Dynamic locators discovery is enabled.");
            }
            System.setProperty("com.gs.jini_lus.locators.dynamic.enabled", Boolean.TRUE.toString());
            System.setProperty("com.gs.multicast.enabled", Boolean.FALSE.toString());
        }
    }

    private static void initJmxIfNeeded(Set<String> services, SystemConfig systemConfig, Configuration config) {
        block7: {
            if (!services.contains(NO_JMX)) {
                try {
                    systemConfig.getJMXServiceDescriptor().create(config);
                }
                catch (Exception e) {
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "Unable to create the MBeanServer", e);
                        break block7;
                    }
                    logger.log(Level.WARNING, "Unable to create the MBeanServer");
                }
            } else if (System.getProperty("com.gs.jmx.enabled") == null && logger.isLoggable(Level.INFO)) {
                logger.info("\n\nJMX is disabled \n\n");
            }
        }
        if (System.getProperty("com.gs.jmx.enabled") == null) {
            System.setProperty("com.gs.jmx.enabled", String.valueOf(!services.contains(NO_JMX)));
        }
    }

    public static String getProcessRole() {
        return processRole;
    }

    private static void preProcess(String[] args) {
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                int eqIdx;
                if (args[i].startsWith("services=")) {
                    args[i] = args[i].replace("services=", "com.gigaspaces.start.services=");
                }
                if ((eqIdx = args[i].indexOf(61)) <= 0) continue;
                if (args[i].length() == eqIdx + 1) {
                    int n = i;
                    args[n] = args[n] + "\"\"";
                    continue;
                }
                if (args[i].charAt(eqIdx + 1) != '\"') {
                    args[i] = args[i].substring(0, eqIdx) + "=\"" + args[i].substring(eqIdx + 1);
                }
                if (args[i].charAt(args[i].length() - 1) == '\"') continue;
                int n = i;
                args[n] = args[n] + "\"";
            }
        }
    }

    private static String getLogFileName(String[] args) {
        String result = System.getenv("GSA_SERVICE_TYPE");
        if (result != null) {
            return result;
        }
        if (args != null) {
            for (String arg : args) {
                int index = arg.indexOf(SERVICES_COMPONENT);
                if (index == -1) continue;
                result = arg.substring(SERVICES_COMPONENT.length() + 1);
                if (result.startsWith("\"")) {
                    result = result.substring(1);
                }
                if (result.endsWith("\"")) {
                    result = result.substring(0, result.length() - 1);
                }
                result = result.replace(',', '_');
                result = result.replace(' ', '_');
                result = result.toLowerCase();
                result = result.replace("lh", "lus");
                return result;
            }
        }
        return null;
    }

    private static Logger getLogger(String logFileName) {
        if (AgentHelper.hasAgentId()) {
            logFileName = logFileName + "_" + AgentHelper.getAgentId();
        }
        System.setProperty("gs.logFileName", logFileName);
        GSLogConfigLoader.getLoader(logFileName);
        return Logger.getLogger(COMPONENT);
    }

    private static void prepareRmiGC() {
        block4: {
            try {
                if (System.getProperty("sun.rmi.dgc.client.gcInterval") == null) {
                    System.setProperty("sun.rmi.dgc.client.gcInterval", "36000000");
                }
                if (System.getProperty("sun.rmi.dgc.server.gcInterval") == null) {
                    System.setProperty("sun.rmi.dgc.server.gcInterval", "36000000");
                }
            }
            catch (Exception secExc) {
                if (!logger.isLoggable(Level.WARNING)) break block4;
                logger.log(Level.WARNING, "Failed to set sun.rmi.dgc.xxx system properties. \n", secExc);
            }
        }
    }

    public static void exitIfHasAgentAndAgentIsNotRunning() {
        if (AgentHelper.hasAgentId()) {
            File file = SystemBoot.findAgentFile(AgentHelper.getGSAServiceID());
            boolean gsaIsOut = false;
            gsaIsOut = file != null && file.exists() ? SystemBoot.isGsaOut(file) : true;
            if (gsaIsOut) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        logger.info("GSA parent missing, exiting");
                    }
                });
                t.start();
                try {
                    t.join(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                outStream.ignore = true;
                errStream.ignore = true;
                System.exit(1);
            }
        }
    }

    private static File findAgentFile(String gsaServiceID) {
        File gsaLocation = new File(SystemInfo.singleton().locations().work(), "gsa");
        File[] files = gsaLocation.listFiles();
        if (files != null) {
            for (File file : files) {
                String name = file.getName();
                if (!name.startsWith("gsa-") || !name.endsWith("~" + gsaServiceID)) continue;
                return file;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isGsaOut(File file) {
        boolean gsaIsOut = false;
        RandomAccessFile raf = null;
        try {
            raf = new RandomAccessFile(file, "rw");
        }
        catch (Exception e) {
            gsaIsOut = false;
        }
        if (raf != null) {
            FileChannel channel = raf.getChannel();
            try {
                FileLock lock = channel.tryLock();
                if (lock != null) {
                    lock.release();
                    gsaIsOut = true;
                }
            }
            catch (Exception e) {
                gsaIsOut = false;
            }
            finally {
                try {
                    channel.close();
                }
                catch (IOException iOException) {}
            }
        }
        return gsaIsOut;
    }

    static {
        shutdownHooks = new ArrayList<Thread>();
        runningWithinGSC = false;
    }

    private static class ControllablePrintStream
    extends PrintStream {
        private final PrintStream stream;
        private boolean ignore = false;

        private ControllablePrintStream(PrintStream stream) {
            super(new NullOutputStream());
            this.stream = stream;
        }

        @Override
        public void flush() {
            if (this.ignore) {
                return;
            }
            this.stream.flush();
        }

        @Override
        public void close() {
            if (this.ignore) {
                return;
            }
            this.stream.close();
        }

        @Override
        public void write(int i) {
            if (this.ignore) {
                return;
            }
            this.stream.write(i);
        }

        @Override
        public void write(byte[] bytes, int i, int i1) {
            if (this.ignore) {
                return;
            }
            this.stream.write(bytes, i, i1);
        }

        @Override
        public void print(boolean b) {
            if (this.ignore) {
                return;
            }
            this.stream.print(b);
        }

        @Override
        public void print(char c) {
            if (this.ignore) {
                return;
            }
            this.stream.print(c);
        }

        @Override
        public void print(int i) {
            if (this.ignore) {
                return;
            }
            this.stream.print(i);
        }

        @Override
        public void print(long l) {
            if (this.ignore) {
                return;
            }
            this.stream.print(l);
        }

        @Override
        public void print(float v) {
            if (this.ignore) {
                return;
            }
            this.stream.print(v);
        }

        @Override
        public void print(double v) {
            if (this.ignore) {
                return;
            }
            this.stream.print(v);
        }

        @Override
        public void print(char[] chars) {
            if (this.ignore) {
                return;
            }
            this.stream.print(chars);
        }

        @Override
        public void print(String s) {
            if (this.ignore) {
                return;
            }
            this.stream.print(s);
        }

        @Override
        public void print(Object o) {
            if (this.ignore) {
                return;
            }
            this.stream.print(o);
        }

        @Override
        public void println() {
            if (this.ignore) {
                return;
            }
            this.stream.println();
        }

        @Override
        public void println(boolean b) {
            if (this.ignore) {
                return;
            }
            this.stream.println(b);
        }

        @Override
        public void println(char c) {
            if (this.ignore) {
                return;
            }
            this.stream.println(c);
        }

        @Override
        public void println(int i) {
            if (this.ignore) {
                return;
            }
            this.stream.println(i);
        }

        @Override
        public void println(long l) {
            if (this.ignore) {
                return;
            }
            this.stream.println(l);
        }

        @Override
        public void println(float v) {
            if (this.ignore) {
                return;
            }
            this.stream.println(v);
        }

        @Override
        public void println(double v) {
            if (this.ignore) {
                return;
            }
            this.stream.println(v);
        }

        @Override
        public void println(char[] chars) {
            if (this.ignore) {
                return;
            }
            this.stream.println(chars);
        }

        @Override
        public void println(String s) {
            if (this.ignore) {
                return;
            }
            this.stream.println(s);
        }

        @Override
        public void println(Object o) {
            if (this.ignore) {
                return;
            }
            this.stream.println(o);
        }

        @Override
        public PrintStream printf(String s, Object ... objects) {
            if (this.ignore) {
                return this;
            }
            return this.stream.printf(s, objects);
        }

        @Override
        public PrintStream printf(Locale locale, String s, Object ... objects) {
            if (this.ignore) {
                return this;
            }
            return this.stream.printf(locale, s, objects);
        }

        @Override
        public PrintStream format(String s, Object ... objects) {
            if (this.ignore) {
                return this;
            }
            return this.stream.format(s, objects);
        }

        @Override
        public PrintStream format(Locale locale, String s, Object ... objects) {
            if (this.ignore) {
                return this;
            }
            return this.stream.format(locale, s, objects);
        }

        @Override
        public PrintStream append(CharSequence charSequence) {
            if (this.ignore) {
                return this;
            }
            return this.stream.append(charSequence);
        }

        @Override
        public PrintStream append(CharSequence charSequence, int i, int i1) {
            if (this.ignore) {
                return this;
            }
            return this.stream.append(charSequence, i, i1);
        }

        @Override
        public PrintStream append(char c) {
            if (this.ignore) {
                return this;
            }
            return this.stream.append(c);
        }

        @Override
        public void write(byte[] bytes) throws IOException {
            if (this.ignore) {
                return;
            }
            this.stream.write(bytes);
        }
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(int i) throws IOException {
        }
    }

    public static class RmiLoaderHandlerCleaner {
        private Class<?> loaderHandlerClass;
        private Field refQueueField;
        private Field loaderTableField;
        private int numberOfFailures = 0;

        public RmiLoaderHandlerCleaner() {
            try {
                this.loaderHandlerClass = this.getClass().getClassLoader().loadClass("sun.rmi.server.LoaderHandler");
                this.refQueueField = this.loaderHandlerClass.getDeclaredField("refQueue");
                this.refQueueField.setAccessible(true);
                this.loaderTableField = this.loaderHandlerClass.getDeclaredField("loaderTable");
                this.loaderTableField.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void clean() {
            if (this.refQueueField == null) {
                return;
            }
            if (this.numberOfFailures > 3) {
                return;
            }
            Class<?> clazz = this.loaderHandlerClass;
            synchronized (clazz) {
                try {
                    Reference entry;
                    ReferenceQueue referenceQueue = (ReferenceQueue)this.refQueueField.get(null);
                    Map loaderTable = (Map)this.loaderTableField.get(null);
                    while ((entry = referenceQueue.poll()) != null) {
                        Field removedField = entry.getClass().getDeclaredField("removed");
                        removedField.setAccessible(true);
                        Field keyField = entry.getClass().getDeclaredField("key");
                        keyField.setAccessible(true);
                        if (((Boolean)removedField.get(entry)).booleanValue()) continue;
                        loaderTable.remove(keyField.get(entry));
                    }
                }
                catch (Throwable e) {
                    ++this.numberOfFailures;
                }
            }
        }
    }
}

