/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.start;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.BootIOUtils;
import com.gigaspaces.internal.jmx.JMXUtilities;
import com.gigaspaces.internal.services.RestServiceFactory;
import com.gigaspaces.internal.services.ServiceFactory;
import com.gigaspaces.internal.services.WebuiServiceFactory;
import com.gigaspaces.internal.services.ZooKeeperServiceFactory;
import com.gigaspaces.start.ClassLoaderType;
import com.gigaspaces.start.ClasspathBuilder;
import com.gigaspaces.start.ConfigurationParser;
import com.gigaspaces.start.Locator;
import com.gigaspaces.start.SystemInfo;
import com.gigaspaces.start.XapModules;
import com.gigaspaces.start.manager.XapManagerConfig;
import com.sun.jini.start.ServiceDescriptor;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.net.BindException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.management.MBeanServer;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import org.jini.rio.boot.BootUtil;
import org.jini.rio.boot.CommonClassLoader;
import org.jini.rio.boot.RioServiceDescriptor;
import org.jini.rio.jmx.MBeanServerFactory;
import org.jini.rio.tools.webster.Webster;

@InternalApi
public class SystemConfig {
    public static final String CODESERVER = "com.gigaspaces.system.codeserver";
    private static final String BASE_COMPONENT = "com.gigaspaces";
    private static final String COMPONENT = "com.gigaspaces.start";
    private static SystemConfig instance;
    private final Configuration config;
    private final String[] configArgs;
    private final String[] configParms;
    private static String[] overrideArgs;
    private Webster webster;
    private final String gsLib;
    private final String gsLibRequired;
    private final String gsLibPlatform;
    private final String gsLibOptional;
    private final String rootDir;
    private static final Logger logger;
    private List<URL> addedPlatformJars;
    private static final int DEFAULT_PORT_RETRIES = 20;
    private final Pattern commonsLoggingPattern;
    private final Map<String, ServiceFactory> serviceFactoryMap = SystemConfig.initServiceFactories();

    private static Map<String, ServiceFactory> initServiceFactories() {
        ServiceFactory[] serviceFactories = new ServiceFactory[]{new RestServiceFactory(), new ZooKeeperServiceFactory(), new WebuiServiceFactory()};
        HashMap<String, ServiceFactory> result = new HashMap<String, ServiceFactory>();
        for (ServiceFactory serviceFactory : serviceFactories) {
            result.put(serviceFactory.getServiceName(), serviceFactory);
        }
        return result;
    }

    private SystemConfig(String[] confArgs) throws ConfigurationException {
        Properties locationProps = Locator.deriveDirectories();
        this.rootDir = Locator.getLocation(locationProps, "com.gs.home");
        this.gsLib = Locator.getLib(locationProps);
        this.gsLibRequired = Locator.getLibRequired(locationProps);
        this.gsLibPlatform = Locator.getLibPlatform(locationProps);
        this.gsLibOptional = Locator.getLibOptional(locationProps);
        if (confArgs == null || confArgs.length == 0) {
            this.configArgs = new String[]{"-"};
            overrideArgs = new String[0];
            this.configParms = new String[0];
        } else {
            if (",".equals(confArgs[confArgs.length - 1])) {
                ArrayList<String> trimConfArgs = new ArrayList<String>(confArgs.length - 1);
                for (int i = 0; i < confArgs.length - 1; ++i) {
                    trimConfArgs.add(confArgs[i]);
                }
                confArgs = trimConfArgs.toArray(new String[trimConfArgs.size()]);
            }
            this.configParms = new String[confArgs.length];
            System.arraycopy(confArgs, 0, this.configParms, 0, this.configParms.length);
            ConfigurationParser configParser = null;
            try {
                configParser = new ConfigurationParser(SystemConfig.class.getClassLoader());
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Creating ConfigurationParser", e);
            }
            String configFile = null;
            ArrayList<String> configList = new ArrayList<String>();
            if (confArgs[0].endsWith(".config")) {
                configFile = confArgs[0];
            }
            for (int i = 0; i < confArgs.length; ++i) {
                if (confArgs[i].endsWith(".xml")) {
                    if (configParser == null) continue;
                    try {
                        String[] args = configParser.parseConfiguration(confArgs[i]);
                        for (int j = 0; j < args.length; ++j) {
                            configList.add(args[j]);
                        }
                        continue;
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Parsing override config file [" + confArgs[i] + "]", e);
                        continue;
                    }
                }
                if (confArgs[i].endsWith(".config")) continue;
                if (!confArgs[i].contains("=") && !confArgs[i].contains("-") && i + 1 < confArgs.length) {
                    if (confArgs[i + 1].contains("=")) continue;
                    configList.add(confArgs[i] + "=\"" + confArgs[++i] + "\"");
                    continue;
                }
                configList.add(confArgs[i]);
            }
            this.addedPlatformJars = new ArrayList<URL>(configList.size());
            Iterator iterator = configList.iterator();
            while (iterator.hasNext()) {
                String configArg = (String)iterator.next();
                if (configArg.indexOf("addPlatformJARs") == -1) continue;
                iterator.remove();
                Configuration config = ConfigurationProvider.getInstance(new String[]{"-", configArg});
                URL[] urls = (URL[])config.getEntry(COMPONENT, "addPlatformJARs", URL[].class, new URL[0]);
                this.addedPlatformJars.addAll(Arrays.asList(urls));
            }
            overrideArgs = configList.toArray(new String[configList.size()]);
            if (configFile != null) {
                this.configArgs = new String[configList.size() + 1];
                URL configFileURL = BootUtil.getResourceURL(configFile, null);
                if (configFileURL != null) {
                    try {
                        this.configArgs[0] = configFileURL.toExternalForm();
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, "Failed to parse Jini Configuration file [" + configFileURL + "].", e);
                    }
                } else {
                    this.configArgs[0] = configFile;
                }
                for (int i = 1; i < this.configArgs.length; ++i) {
                    this.configArgs[i] = (String)configList.get(i - 1);
                }
            } else {
                this.configArgs = new String[configList.size() + 1];
                this.configArgs[0] = "-";
                for (int i = 1; i < this.configArgs.length; ++i) {
                    this.configArgs[i] = (String)configList.get(i - 1);
                }
            }
        }
        this.config = ConfigurationProvider.getInstance(this.configArgs);
        this.commonsLoggingPattern = Pattern.compile("commons-logging.*\\.jar");
    }

    public static synchronized SystemConfig getInstance(String[] configArgs) throws ConfigurationException {
        if (instance == null) {
            instance = new SystemConfig(configArgs);
        }
        return instance;
    }

    public static synchronized SystemConfig getInstance() {
        if (instance == null) {
            throw new RuntimeException("SystemConfig instance must be created with a configuration");
        }
        return instance;
    }

    public String getHomeDir() {
        return this.rootDir;
    }

    public String[] getConfigurationParms() {
        return this.configParms;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public static String[] appendOverrides(String configFile) {
        if (configFile == null) {
            throw new NullPointerException("configFie is null");
        }
        String[] confArgs = overrideArgs != null ? new String[overrideArgs.length + 1] : new String[]{""};
        confArgs[0] = configFile;
        if (overrideArgs != null && overrideArgs.length > 0) {
            for (int i = 1; i < confArgs.length; ++i) {
                confArgs[i] = overrideArgs[i - 1];
            }
        }
        return confArgs;
    }

    public String[] getOverrides() {
        return overrideArgs;
    }

    private List<URL> getDefaultCommonClassLoaderClasspath() throws MalformedURLException {
        boolean osInCommonClassLoader;
        ClasspathBuilder classpathBuilder;
        block5: {
            classpathBuilder = new ClasspathBuilder();
            try {
                String commonsLoggingJarFilename = SystemConfig.findJarFilenameByRegexPattern(this.gsLibRequired, this.commonsLoggingPattern);
                classpathBuilder.append(this.gsLibRequired + commonsLoggingJarFilename);
            }
            catch (FileNotFoundException e) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.log(Level.WARNING, "Missing JAR file", e);
            }
        }
        for (XapModules module : XapModules.getByClassLoaderType(ClassLoaderType.COMMON)) {
            classpathBuilder.append(this.gsLib + module.getJarFilePath());
        }
        classpathBuilder.appendOptional("jee");
        classpathBuilder.append(System.getProperty("com.gigaspaces.lib.platform.ext", this.gsLibPlatform + "ext"));
        classpathBuilder.appendOptional("jms");
        classpathBuilder.appendOptional("metrics");
        classpathBuilder.appendOptional("spatial");
        classpathBuilder.appendOptional("full-text-search");
        classpathBuilder.appendOptional("jpa", new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !file.getName().equals(XapModules.JPA_SPRING.getJarFileName());
            }
        });
        classpathBuilder.appendPlatform("commons");
        classpathBuilder.appendOptional("groovy");
        classpathBuilder.appendOptional("jruby");
        classpathBuilder.append(System.getProperty("com.gs.pu.classloader.scala-lib-path", this.gsLibOptional + "scala/lib"));
        classpathBuilder.appendPlatform("zookeeper");
        classpathBuilder.appendPlatform("logger");
        classpathBuilder.appendOptional("oshi");
        if (SystemConfig.isJava11()) {
            classpathBuilder.appendPlatform("javax");
        }
        if (osInCommonClassLoader = Boolean.parseBoolean(System.getProperty("com.gs.pu.classloader.os-in-common-classloader", "false"))) {
            classpathBuilder.append(this.gsLibRequired);
            classpathBuilder.appendOptional("spring");
        }
        return classpathBuilder.toURLs();
    }

    public URL[] getPlatformJars() throws MalformedURLException, ConfigurationException {
        int i;
        StringBuilder buffer;
        List<URL> defaultPlatformJARsList = this.getDefaultCommonClassLoaderClasspath();
        URL[] defaultPlatformJARs = defaultPlatformJARsList.toArray(new URL[defaultPlatformJARsList.size()]);
        URL[] platformJARs = (URL[])this.config.getEntry(COMPONENT, "platformJARs", URL[].class, defaultPlatformJARs);
        URL[] addPlatformJARs = this.addedPlatformJars.toArray(new URL[this.addedPlatformJars.size()]);
        if (addPlatformJARs.length > 0) {
            if (logger.isLoggable(Level.CONFIG)) {
                buffer = new StringBuilder();
                for (i = 0; i < addPlatformJARs.length; ++i) {
                    if (i > 0) {
                        buffer.append("\n");
                    }
                    buffer.append("    " + addPlatformJARs[i].toExternalForm());
                }
                logger.config("addPlatformJARs\n" + buffer.toString());
            }
            ArrayList<URL> list = new ArrayList<URL>();
            for (i = 0; i < platformJARs.length; ++i) {
                list.add(platformJARs[i]);
            }
            for (i = 0; i < addPlatformJARs.length; ++i) {
                list.add(addPlatformJARs[i]);
            }
            platformJARs = list.toArray(new URL[list.size()]);
        }
        if (logger.isLoggable(Level.FINE)) {
            buffer = new StringBuilder();
            for (i = 0; i < platformJARs.length; ++i) {
                if (i > 0) {
                    buffer.append("\n");
                }
                buffer.append("    " + platformJARs[i].toExternalForm());
            }
            logger.fine("platform JARs\n" + buffer.toString());
        }
        return platformJARs;
    }

    private static String findJarFilenameByRegexPattern(String folderPath, final Pattern pattern) throws FileNotFoundException {
        File folder = new File(folderPath);
        if (!folder.isDirectory()) {
            throw new FileNotFoundException(folder + " is not a directory.");
        }
        File[] files = folder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return pattern.matcher(file.getName()).matches();
            }
        });
        if (files.length != 1) {
            throw new FileNotFoundException("Folder " + folderPath + " should contain exactly one jar that satisfies the pattern " + pattern.toString());
        }
        return files[0].getName();
    }

    public Properties getSystemProperties() throws ConfigurationException, UnknownHostException {
        String[] gridGroups = (String[])this.config.getEntry("com.gigaspaces.grid", "groups", String[].class, new String[]{"gs-grid"});
        StringBuilder buff = new StringBuilder();
        for (int i = 0; i < gridGroups.length; ++i) {
            if (i > 0) {
                buff.append(",");
            }
            buff.append(gridGroups[i]);
        }
        String groupNames = buff.toString();
        Properties sysProps = new Properties();
        sysProps.setProperty("java.protocol.handler.pkgs", "net.jini.url");
        sysProps.setProperty("com.gs.home", this.rootDir);
        sysProps.setProperty("com.gs.localhost.name", this.getDefaultHostAddress());
        sysProps.setProperty("com.gigaspaces.grid.groups", groupNames);
        String[] systemProperties = (String[])this.config.getEntry(COMPONENT, "systemProperties", String[].class, new String[0]);
        if (systemProperties.length > 0) {
            if (systemProperties.length % 2 != 0) {
                logger.log(Level.WARNING, "systemProperties elements has odd length : " + systemProperties.length);
            } else {
                for (int i = 0; i < systemProperties.length; i += 2) {
                    String name = systemProperties[i];
                    String value = systemProperties[i + 1];
                    sysProps.setProperty(name, value);
                }
            }
        }
        return sysProps;
    }

    String fix(String s) {
        if (s.endsWith(File.separator)) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    public String getWebsterProtocol() {
        if (this.webster != null) {
            return this.webster.getProtocol();
        }
        return "http";
    }

    public int getWebsterPort() {
        if (this.webster != null) {
            return this.webster.getPort();
        }
        return -1;
    }

    public Webster getWebster() throws BindException, ConfigurationException, UnknownHostException {
        if (this.webster == null) {
            String deployRoot = System.getProperty("com.gs.deploy", this.rootDir + "deploy");
            System.setProperty("com.gs.deploy", deployRoot);
            File deployRootFile = new File(deployRoot);
            if (!deployRootFile.exists()) {
                deployRootFile.mkdirs();
            }
            String defaultRoots = this.gsLib + ";" + this.gsLibRequired + ";" + deployRoot;
            String httpRoots = (String)this.config.getEntry(COMPONENT, "httpRoots", String.class, defaultRoots);
            httpRoots = System.getProperty("com.gigaspaces.start.httpRoots", httpRoots);
            String addHttpRoots = (String)this.config.getEntry(COMPONENT, "addHttpRoots", String.class, null);
            if ((addHttpRoots = System.getProperty("com.gigaspaces.start.addHttpRoots", addHttpRoots)) != null) {
                httpRoots = httpRoots + ";" + addHttpRoots;
            }
            int httpPort = (Integer)this.config.getEntry(COMPONENT, "httpPort", Integer.TYPE, 0);
            httpPort = Integer.getInteger("com.gigaspaces.start.httpPort", httpPort);
            int httpServerRetries = (Integer)this.config.getEntry(COMPONENT, "httpServerRetries", Integer.class, 20);
            httpServerRetries = Integer.getInteger("com.gigaspaces.start.httpServerRetries", httpServerRetries);
            XapManagerConfig currServer = SystemInfo.singleton().getManagerClusterInfo().getCurrServer();
            String hostAddress = currServer != null ? SystemInfo.singleton().network().getHost().getHostAddress() : this.getDefaultHostAddress();
            for (int i = 0; i < httpServerRetries; ++i) {
                try {
                    this.webster = new Webster(httpPort, httpRoots, hostAddress);
                    break;
                }
                catch (BindException e) {
                    if (httpPort == 0) {
                        throw e;
                    }
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.finest("Failed to create HTTP server using port [" + httpPort + "], increment port and try again");
                    }
                    ++httpPort;
                    continue;
                }
            }
            if (this.webster == null) {
                throw new RuntimeException("Failed to create HTTP server");
            }
            System.setProperty(CODESERVER, this.webster.getURL());
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Created Webster on " + this.webster.getURL() + " [roots=" + httpRoots + "]");
            }
        }
        return this.webster;
    }

    private ServiceDescriptor getLookupHandlerServiceDescriptor() throws BindException, UnknownHostException, ConfigurationException {
        String handlerCodebase = this.getDefaultCodebase();
        String handlerClasspath = "";
        String configDir = this.rootDir + "config" + File.separator + "services" + File.separator;
        String reggieConfig = (String)this.config.getEntry(COMPONENT, "reggieConfig", String.class, configDir + "services.config");
        String[] confArgs = new String[overrideArgs.length + 1];
        confArgs[0] = reggieConfig;
        if (overrideArgs.length > 0) {
            for (int i = 1; i < confArgs.length; ++i) {
                confArgs[i] = overrideArgs[i - 1];
            }
        }
        return new RioServiceDescriptor("LUS", handlerCodebase, handlerClasspath, "com.gigaspaces.grid.lookup.LookupHandler", confArgs);
    }

    private String getDefaultCodebase() throws UnknownHostException {
        return BootUtil.getCodebase(new String[]{XapModules.DATA_GRID.getJarFileName()}, this.getWebsterProtocol(), Integer.toString(this.getWebsterPort()));
    }

    private ServiceDescriptor getMahaloServiceDescriptor() throws BindException, UnknownHostException, ConfigurationException {
        String handlerCodebase = this.getDefaultCodebase();
        String handlerClasspath = "";
        String configDir = this.rootDir + "config" + File.separator + "services" + File.separator;
        String mahaloConfig = (String)this.config.getEntry(COMPONENT, "mahaloConfig", String.class, configDir + "services.config");
        String[] confArgs = new String[overrideArgs.length + 1];
        confArgs[0] = mahaloConfig;
        if (overrideArgs.length > 0) {
            for (int i = 1; i < confArgs.length; ++i) {
                confArgs[i] = overrideArgs[i - 1];
            }
        }
        return new RioServiceDescriptor("TM", handlerCodebase, handlerClasspath, "com.sun.jini.mahalo.TransientMahaloImpl", confArgs);
    }

    public ServiceDescriptor getServiceDescriptor(String key) throws BindException, ConfigurationException, UnknownHostException {
        if (key.equals("GSC")) {
            return this.getGSCServiceDescriptor();
        }
        if (key.equals("GSA")) {
            return this.getGSAServiceDescriptor();
        }
        if (key.equals("GSM")) {
            return this.getGSMServiceDescriptor();
        }
        if (key.equals("GS")) {
            return this.getGSServiceDescriptor();
        }
        if (key.equals("LH")) {
            return this.getLookupHandlerServiceDescriptor();
        }
        if (key.equals("TM")) {
            return this.getMahaloServiceDescriptor();
        }
        if (key.equals("ESM")) {
            return this.getESMServiceDescriptor();
        }
        return null;
    }

    public Closeable getCustomService(String key) {
        ServiceFactory serviceFactory = this.serviceFactoryMap.get(key);
        if (serviceFactory != null) {
            return serviceFactory.createService();
        }
        logger.warning("Service " + key + " was not created - service factory was not found");
        return null;
    }

    private ServiceDescriptor getGSAServiceDescriptor() throws UnknownHostException, ConfigurationException {
        ServiceDescriptor svcDesc = (ServiceDescriptor)this.config.getEntry("com.gigaspaces.start.gsa", "svcDesc", ServiceDescriptor.class, null);
        if (svcDesc == null) {
            StringBuilder defaultGSAClasspath = new StringBuilder();
            this.addRequiredLibs(defaultGSAClasspath);
            this.addOptionalSpringLibs(defaultGSAClasspath);
            this.addOptionalSecurityLibs(defaultGSAClasspath);
            String gsaClasspath = (String)this.config.getEntry("com.gigaspaces.start.gsa", "classpath", String.class, defaultGSAClasspath.toString());
            String gsaCodebase = this.getDefaultCodebase();
            String configDir = this.rootDir + "config" + File.separator + "services" + File.separator;
            String gscConfig = (String)this.config.getEntry(COMPONENT, "gsaConfig", String.class, configDir + "services.config");
            String[] confArgs = new String[overrideArgs.length + 1];
            confArgs[0] = gscConfig;
            if (overrideArgs.length > 0) {
                for (int i = 1; i < confArgs.length; ++i) {
                    confArgs[i] = overrideArgs[i - 1];
                }
            }
            svcDesc = new RioServiceDescriptor("GSA", gsaCodebase, gsaClasspath, "com.gigaspaces.grid.gsa.GSAImpl", confArgs);
        }
        return svcDesc;
    }

    private ServiceDescriptor getGSCServiceDescriptor() throws UnknownHostException, BindException, ConfigurationException {
        ServiceDescriptor svcDesc = (ServiceDescriptor)this.config.getEntry("com.gigaspaces.start.gsc", "svcDesc", ServiceDescriptor.class, null);
        if (svcDesc == null) {
            StringBuilder defaultGSCClasspath = new StringBuilder();
            this.addRequiredLibs(defaultGSCClasspath);
            this.addOptionalSpringLibs(defaultGSCClasspath);
            this.addOptionalSecurityLibs(defaultGSCClasspath);
            String gscClasspath = (String)this.config.getEntry("com.gigaspaces.start.gsc", "classpath", String.class, defaultGSCClasspath.toString());
            logger.fine("GSC configuration Classpath is: " + gscClasspath);
            String gscCodebase = this.getDefaultCodebase();
            String configDir = this.rootDir + "config" + File.separator + "services" + File.separator;
            String gscConfig = (String)this.config.getEntry(COMPONENT, "gscConfig", String.class, configDir + "services.config");
            String[] confArgs = new String[overrideArgs.length + 1];
            confArgs[0] = gscConfig;
            if (overrideArgs.length > 0) {
                for (int i = 1; i < confArgs.length; ++i) {
                    confArgs[i] = overrideArgs[i - 1];
                }
            }
            svcDesc = new RioServiceDescriptor("GSC", gscCodebase, gscClasspath, "com.gigaspaces.grid.gsc.GSCImpl", confArgs);
        }
        return svcDesc;
    }

    private ServiceDescriptor getGSMServiceDescriptor() throws UnknownHostException, BindException, ConfigurationException {
        ServiceDescriptor svcDesc = (ServiceDescriptor)this.config.getEntry("com.gigaspaces.start.gsm", "svcDesc", ServiceDescriptor.class, null);
        if (svcDesc == null) {
            StringBuilder defaultGSMClasspath = new StringBuilder();
            this.addRequiredLibs(defaultGSMClasspath);
            this.addOptionalSpringLibs(defaultGSMClasspath);
            this.addOptionalSecurityLibs(defaultGSMClasspath);
            defaultGSMClasspath.append(this.gsLib + XapModules.ADMIN.getJarFilePath() + File.pathSeparator);
            String gsmClasspath = (String)this.config.getEntry("com.gigaspaces.start.gsm", "classpath", String.class, defaultGSMClasspath.toString());
            String gsmCodebase = this.getDefaultCodebase();
            String configDir = this.rootDir + "config" + File.separator + "services" + File.separator;
            String gsmConfig = (String)this.config.getEntry(COMPONENT, "gsmConfig", String.class, configDir + "services.config");
            String[] confArgs = new String[overrideArgs.length + 1];
            confArgs[0] = gsmConfig;
            if (overrideArgs.length > 0) {
                for (int i = 1; i < confArgs.length; ++i) {
                    confArgs[i] = overrideArgs[i - 1];
                }
            }
            svcDesc = new RioServiceDescriptor("GSM", gsmCodebase, gsmClasspath, "com.gigaspaces.grid.gsm.GSMImpl", confArgs);
        }
        return svcDesc;
    }

    private void addRequiredLibs(StringBuilder classpath) {
        for (File f : BootIOUtils.listFiles(new File(this.gsLibRequired))) {
            if (f.getName().contains(XapModules.DATA_GRID.getJarFileName()) || f.getName().contains(XapModules.CORE_REFLECTIONS_ASM.getJarFileName())) continue;
            classpath.append(f.getAbsolutePath()).append(File.pathSeparator);
        }
    }

    private void addOptionalSpringLibs(StringBuilder classpath) {
        this.addLibs(classpath, this.gsLibOptional + "spring");
    }

    private void addLibs(StringBuilder classpath, String path) {
        File libDir = new File(path);
        if (libDir.exists() && libDir.isDirectory()) {
            for (File f : BootIOUtils.listFiles(libDir)) {
                if (logger.isLoggable(Level.FINE)) {
                    logger.fine("Adding " + f.getAbsolutePath() + " to ClassPath");
                }
                classpath.append(f.getAbsolutePath()).append(File.pathSeparator);
            }
        }
    }

    private void addOptionalSecurityLibs(StringBuilder classpath) {
        this.addLibs(classpath, Locator.getLibOptionalSecurity());
    }

    private ServiceDescriptor getESMServiceDescriptor() throws UnknownHostException, BindException, ConfigurationException {
        ServiceDescriptor svcDesc = (ServiceDescriptor)this.config.getEntry("com.gigaspaces.start.esm", "svcDesc", ServiceDescriptor.class, null);
        if (svcDesc == null) {
            StringBuilder defaultESMClasspath = new StringBuilder();
            this.addRequiredLibs(defaultESMClasspath);
            this.appendLibPlatformToClasspath(defaultESMClasspath, "esm");
            this.addOptionalSpringLibs(defaultESMClasspath);
            this.addOptionalSecurityLibs(defaultESMClasspath);
            defaultESMClasspath.append(this.gsLib + XapModules.ADMIN.getJarFilePath() + File.pathSeparator);
            String esmClasspath = (String)this.config.getEntry("com.gigaspaces.start.esm", "classpath", String.class, defaultESMClasspath.toString());
            String esmCodebase = this.getDefaultCodebase();
            String configDir = this.rootDir + "config" + File.separator + "services" + File.separator;
            String gsmConfig = (String)this.config.getEntry(COMPONENT, "esmConfig", String.class, configDir + "services.config");
            String[] confArgs = new String[overrideArgs.length + 1];
            confArgs[0] = gsmConfig;
            if (overrideArgs.length > 0) {
                for (int i = 1; i < confArgs.length; ++i) {
                    confArgs[i] = overrideArgs[i - 1];
                }
            }
            svcDesc = new RioServiceDescriptor("ESM", esmCodebase, esmClasspath, "org.openspaces.grid.esm.ESMImpl", confArgs);
        }
        return svcDesc;
    }

    private void appendLibPlatformToClasspath(StringBuilder defaultESMClasspath, String platformName) {
        File lib = new File(this.gsLibPlatform + "/" + platformName);
        if (lib.exists() && lib.isDirectory()) {
            for (File f : BootIOUtils.listFiles(lib)) {
                defaultESMClasspath.append(f.getAbsolutePath()).append(File.pathSeparator);
            }
        }
    }

    public ServiceDescriptor getJMXServiceDescriptor() throws ConfigurationException {
        ServiceDescriptor svcDesc = (ServiceDescriptor)this.config.getEntry("com.gigaspaces.start.jmx", "svcDesc", ServiceDescriptor.class, null);
        if (svcDesc == null) {
            svcDesc = new JMXServiceDescriptor();
        }
        return svcDesc;
    }

    private ServiceDescriptor getGSServiceDescriptor() throws UnknownHostException, BindException, ConfigurationException {
        String gsClasspath = "";
        String gsCodebase = this.getDefaultCodebase();
        String configDir = this.rootDir + "config" + File.separator + "services" + File.separator;
        String gsConfig = (String)this.config.getEntry(COMPONENT, "gsConfig", String.class, configDir + "services.config");
        String[] confArgs = new String[overrideArgs.length + 1];
        confArgs[0] = gsConfig;
        if (overrideArgs.length > 0) {
            for (int i = 1; i < confArgs.length; ++i) {
                confArgs[i] = overrideArgs[i - 1];
            }
        }
        RioServiceDescriptor svcDesc = new RioServiceDescriptor("GS", gsCodebase, gsClasspath, "com.j_spaces.start.JSpaceServiceImpl", confArgs);
        return svcDesc;
    }

    String getDefaultHostAddress() throws UnknownHostException, ConfigurationException {
        String defaultAddress = SystemInfo.singleton().network().getHostId();
        String hostAddress = (String)this.config.getEntry(COMPONENT, "hostAddress", String.class, defaultAddress);
        hostAddress = System.getProperty("com.gigaspaces.start.hostAddress", hostAddress);
        return hostAddress;
    }

    private static boolean isJava11() {
        String javaVersion = System.getProperty("java.version");
        if (javaVersion == null) {
            return false;
        }
        String majorVersion = javaVersion.substring(0, javaVersion.indexOf("."));
        return majorVersion.equals("11");
    }

    static {
        logger = Logger.getLogger(COMPONENT);
    }

    public static class JMXServiceDescriptor
    implements ServiceDescriptor {
        @Override
        public Object create(Configuration config) throws Exception {
            MBeanServer mbs = null;
            int registryPort = (Integer)JMXServiceDescriptor.getConfigEntry(config, SystemConfig.COMPONENT, "registryPort", Integer.TYPE, "com.gigaspaces.system.registryPort", 10098);
            int registryRetries = (Integer)JMXServiceDescriptor.getConfigEntry(config, SystemConfig.COMPONENT, "registryRetries", Integer.class, "com.gigaspaces.system.registryRetries", 20);
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(CommonClassLoader.getInstance());
            int jmxRemotePort = -1;
            String jmxRemotePortStr = System.getProperty("com.sun.management.jmxremote.port");
            if (jmxRemotePortStr != null) {
                try {
                    jmxRemotePort = Integer.parseInt(jmxRemotePortStr);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, e.toString(), e);
                }
            }
            if (jmxRemotePort > 0) {
                logger.info("System property [com.sun.management.jmxremote.port] has value:" + jmxRemotePort);
            }
            Registry registry = null;
            if (jmxRemotePort < 0) {
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Starting RMI Registry initialization: initial port=" + registryPort + ", retries=" + registryRetries);
                }
                RemoteException registryCreationException = null;
                for (int i = 0; i < registryRetries; ++i) {
                    try {
                        registry = LocateRegistry.createRegistry(registryPort);
                        break;
                    }
                    catch (RemoteException e) {
                        registryCreationException = e;
                        if (logger.isLoggable(Level.FINEST)) {
                            logger.finest("Failed to create RMI Registry using port [" + registryPort + "], increment port and try again");
                        }
                        ++registryPort;
                        continue;
                    }
                }
                Thread.currentThread().setContextClassLoader(cl);
                if (registry == null) {
                    logger.log(Level.SEVERE, "Unable to create RMI Registry, tried port range [" + (registryPort - (registryRetries - 1)) + "-" + (registryPort - 1) + "], you can change the port and range using '" + "com.gigaspaces.system.registryPort" + ", " + "com.gigaspaces.system.registryRetries" + "'", registryCreationException);
                } else {
                    System.setProperty("com.gigaspaces.system.registryPort", Integer.toString(registryPort));
                    if (logger.isLoggable(Level.FINE)) {
                        logger.fine("Created RMI Registry: " + registry.toString() + " using port " + registryPort);
                    }
                    String defaultAddress = SystemInfo.singleton().network().getHostId();
                    String hostAddress = (String)config.getEntry(SystemConfig.COMPONENT, "hostAddress", String.class, defaultAddress);
                    String publicHostAddress = SystemInfo.singleton().network().getPublicHostId();
                    mbs = MBeanServerFactory.getMBeanServer();
                    if (mbs != null) {
                        String jmxServiceURL = JMXUtilities.createJMXUrl(hostAddress, registryPort);
                        String jmxServicePublicURL = JMXUtilities.createJMXUrl(publicHostAddress, registryPort);
                        System.setProperty("com.gs.jmx.enabled", Boolean.TRUE.toString());
                        System.setProperty("com.gs.jmx.createJmxConnetor", Boolean.FALSE.toString());
                        long start = System.currentTimeMillis();
                        JMXConnectorServer jmxConn = JMXConnectorServerFactory.newJMXConnectorServer(new JMXServiceURL(jmxServiceURL), System.getProperties(), mbs);
                        jmxConn.start();
                        System.setProperty("com.gigaspaces.system.jmxServiceURL", jmxServiceURL);
                        System.setProperty("com.gigaspaces.system.jmxDockerServicePublicURL", jmxServicePublicURL);
                        long duration = System.currentTimeMillis() - start;
                        if (logger.isLoggable(Level.INFO)) {
                            logger.info("Exported JMX Platform MBeanServer with RMI Connector [duration=" + BootUtil.formatDuration(duration) + ", url=" + jmxServiceURL + "]");
                        }
                    } else {
                        logger.info("Unable to acquire JMX Platform MBeanServer, running with Java version " + System.getProperty("java.version"));
                    }
                }
            } else {
                String defaultAddress = SystemInfo.singleton().network().getHostId();
                String hostAddress = (String)config.getEntry(SystemConfig.COMPONENT, "hostAddress", String.class, defaultAddress);
                mbs = MBeanServerFactory.getMBeanServer();
                if (mbs != null) {
                    String publicHostAddress = SystemInfo.singleton().network().getPublicHostId();
                    String jmxServiceURL = JMXUtilities.createJMXUrl(hostAddress, jmxRemotePort);
                    String jmxServicePublicURL = JMXUtilities.createJMXUrl(publicHostAddress, registryPort);
                    System.setProperty("com.gs.jmx.enabled", Boolean.TRUE.toString());
                    System.setProperty("com.gs.jmx.createJmxConnetor", Boolean.FALSE.toString());
                    System.setProperty("com.gigaspaces.system.jmxServiceURL", jmxServiceURL);
                    System.setProperty("com.gigaspaces.system.jmxDockerServicePublicURL", jmxServicePublicURL);
                } else {
                    logger.info("Unable to acquire JMX Platform MBeanServer, running with Java version " + System.getProperty("java.version"));
                }
            }
            return mbs;
        }

        private static Object getConfigEntry(Configuration config, String component, String name, Class<?> type, String systemProperty, int defaultValue) throws ConfigurationException {
            String propertyValue = System.getProperty(systemProperty);
            if (propertyValue != null) {
                defaultValue = Integer.parseInt(propertyValue);
            }
            return config.getEntry(component, name, type, defaultValue);
        }
    }
}

