/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.start;

import com.gigaspaces.api.InternalApi;
import com.gigaspaces.internal.io.BootIOUtils;
import com.gigaspaces.internal.version.PlatformVersion;
import com.gigaspaces.logger.LoggerSystemInfo;
import com.gigaspaces.start.XapNetworkInfo;
import com.gigaspaces.start.manager.XapManagerClusterInfo;
import com.gigaspaces.start.manager.XapManagerConfig;
import com.gigaspaces.time.AbsoluteTime;
import com.gigaspaces.time.ITimeProvider;
import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.jini.core.discovery.LookupLocator;

@InternalApi
public class SystemInfo {
    public static final String XAP_LOOKUP_GROUPS = "com.gs.jini_lus.groups";
    public static final String XAP_LOOKUP_LOCATORS = "com.gs.jini_lus.locators";
    private static final SystemInfo instance = new SystemInfo();
    private final String xapHome = LoggerSystemInfo.xapHome;
    private final String xapHomeFwdSlash = new File(this.xapHome).toString().replace("\\", "/");
    private final XapLocations locations;
    private final XapLookup lookup;
    private final XapNetworkInfo network;
    private final XapOperatingSystem os;
    private final XapTimeProvider timeProvider;
    private final XapManagerClusterInfo managerClusterInfo;

    public static SystemInfo singleton() {
        return instance;
    }

    private SystemInfo() {
        System.setProperty("com.gs.home.fwd-slash", this.xapHomeFwdSlash);
        this.os = new XapOperatingSystem(LoggerSystemInfo.processId);
        this.network = XapNetworkInfo.getInstance();
        this.locations = new XapLocations(this.xapHome);
        this.timeProvider = new XapTimeProvider();
        this.managerClusterInfo = new XapManagerClusterInfo(this.network.getPublicHost());
        this.lookup = new XapLookup(this.managerClusterInfo);
    }

    public String getXapHome() {
        return this.xapHome;
    }

    public String getXapHomeFwdSlash() {
        return this.xapHomeFwdSlash;
    }

    public XapLocations locations() {
        return this.locations;
    }

    public XapLookup lookup() {
        return this.lookup;
    }

    public XapNetworkInfo network() {
        return this.network;
    }

    public XapOperatingSystem os() {
        return this.os;
    }

    public XapManagerClusterInfo getManagerClusterInfo() {
        return this.managerClusterInfo;
    }

    public XapTimeProvider timeProvider() {
        return this.timeProvider;
    }

    public static class XapTimeProvider {
        private final ITimeProvider _timeProvider;

        public XapTimeProvider() {
            String timeProviderClassName = System.getProperty("com.gs.time-provider");
            if (timeProviderClassName == null || timeProviderClassName.length() == 0) {
                this._timeProvider = new AbsoluteTime();
            } else {
                try {
                    Class<?> timeProviderClass = Class.forName(timeProviderClassName);
                    Object timeProvider = timeProviderClass.newInstance();
                    this._timeProvider = (ITimeProvider)timeProvider;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Unable to load time-provider: " + timeProviderClassName + " - verify that this provider class is in the classpath", e);
                }
                catch (Throwable e) {
                    throw new RuntimeException("Unable to load time-provider: " + timeProviderClassName, e);
                }
            }
        }

        public String getTimeProviderName() {
            return this._timeProvider.getClass().getName();
        }

        public boolean isRelativeTime() {
            return this._timeProvider.isRelative();
        }

        public long timeMillis() {
            return this._timeProvider.timeMillis();
        }
    }

    public static class XapOperatingSystem {
        private final long processId;
        private final boolean isWindows = System.getProperty("os.name").toLowerCase().startsWith("win");

        public XapOperatingSystem(long pid) {
            this.processId = pid;
        }

        public long processId() {
            return this.processId;
        }

        public boolean isWindows() {
            return this.isWindows;
        }
    }

    public static class XapLookup {
        private static final String SEPARATOR = ",";
        private String groups;
        private String[] groupsArray;
        private String locators;
        private LookupLocator[] locatorsArray;

        private XapLookup(XapManagerClusterInfo managerClusterInfo) {
            this.setGroups(System.getProperty(SystemInfo.XAP_LOOKUP_GROUPS, System.getenv("XAP_LOOKUP_GROUPS")));
            String explicitLocators = System.getProperty(SystemInfo.XAP_LOOKUP_LOCATORS, System.getenv("XAP_LOOKUP_LOCATORS"));
            String managerLocators = XapLookup.toLocators(managerClusterInfo);
            if (!(BootIOUtils.isEmpty(managerLocators) || BootIOUtils.isEmpty(explicitLocators) || managerLocators.equals(explicitLocators))) {
                throw new IllegalStateException("Ambiguous locators: Manager locators: [" + managerLocators + "], explicit locators: [" + explicitLocators + "]");
            }
            this.setLocators(!managerLocators.isEmpty() ? managerLocators : explicitLocators);
        }

        private static String toLocators(XapManagerClusterInfo managerClusterInfo) {
            String result = "";
            for (XapManagerConfig managerConfig : managerClusterInfo.getServers()) {
                String locator = managerConfig.getHost();
                if (managerConfig.getLookupService() != null) {
                    locator = locator + ":" + managerConfig.getLookupService();
                }
                result = result.isEmpty() ? locator : result + SEPARATOR + locator;
            }
            return result;
        }

        public String defaultGroups() {
            return "xap-" + PlatformVersion.getVersion();
        }

        public String groups() {
            return this.groups;
        }

        public String[] groupsArray() {
            return this.groupsArray;
        }

        public String locators() {
            return this.locators;
        }

        public LookupLocator[] locatorsArray() {
            return this.locatorsArray;
        }

        public String setGroups(String groups) {
            String prevValue = this.groups;
            if (groups != null) {
                groups = groups.trim();
            }
            if (groups == null || groups.length() == 0) {
                groups = this.defaultGroups();
            }
            this.groups = groups;
            XapLookup.setSystemProperty(SystemInfo.XAP_LOOKUP_GROUPS, groups);
            List<String> groupsList = XapLookup.toList(groups, SEPARATOR);
            this.groupsArray = groupsList.toArray(new String[groupsList.size()]);
            return prevValue;
        }

        public void setGroups(String[] lookupGroups) {
            this.setGroups(XapLookup.join(lookupGroups, SEPARATOR));
        }

        public String setLocators(String locators) {
            String prevValue = this.locators;
            this.locators = locators;
            XapLookup.setSystemProperty(SystemInfo.XAP_LOOKUP_LOCATORS, locators);
            List<String> locatorsList = XapLookup.toList(locators, SEPARATOR);
            this.locatorsArray = new LookupLocator[locatorsList == null ? 0 : locatorsList.size()];
            for (int i = 0; i < this.locatorsArray.length; ++i) {
                try {
                    this.locatorsArray[i] = new LookupLocator("jini://" + locatorsList.get(i));
                    continue;
                }
                catch (MalformedURLException e) {
                    throw new IllegalStateException("Failed to generate locators for " + locatorsList.get(i), e);
                }
            }
            return prevValue;
        }

        private static String join(String[] array, String separator) {
            if (array == null) {
                return null;
            }
            if (array.length == 0) {
                return "";
            }
            if (array.length == 1) {
                return array[0];
            }
            StringBuilder sb = new StringBuilder(array[0]);
            for (int i = 1; i < array.length; ++i) {
                sb.append(separator).append(array[i]);
            }
            return sb.toString();
        }

        private static List<String> toList(String s, String separator) {
            if (s == null) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            StringTokenizer tokenizer = new StringTokenizer(s, separator);
            while (tokenizer.hasMoreTokens()) {
                result.add(tokenizer.nextToken().trim());
            }
            return result;
        }

        private static String setSystemProperty(String key, String value) {
            return value != null ? System.setProperty(key, value) : System.clearProperty(key);
        }
    }

    public static class XapLocations {
        private final String xapNetHome;
        private final String bin;
        private final String config;
        private final String lib;
        private final String libRequired;
        private final String libOptional;
        private final String libOptionalSecurity;
        private final String libPlatform;
        private final String work;
        private final String deploy;
        private final String insightedge;
        private final String sparkHome;

        public String getSparkHome() {
            return this.sparkHome;
        }

        private XapLocations(String xapHome) {
            if (xapHome.endsWith("/") || xapHome.endsWith("\\")) {
                xapHome = xapHome.substring(0, xapHome.length() - 1);
            }
            this.xapNetHome = System.getProperty("com.gs.xapnet.home");
            this.bin = XapLocations.path(this.xapNetHome != null ? this.xapNetHome : xapHome, "bin");
            this.config = XapLocations.path(xapHome, "config");
            this.lib = XapLocations.path(xapHome, "lib");
            this.libRequired = XapLocations.path(this.lib, "required");
            this.libOptional = XapLocations.path(this.lib, "optional");
            this.libOptionalSecurity = XapLocations.initFromSystemProperty("com.gigaspaces.lib.opt.security", XapLocations.path(this.libOptional, "security"));
            this.libPlatform = XapLocations.path(this.lib, "platform");
            this.work = XapLocations.initFromSystemProperty("com.gs.work", XapLocations.path(xapHome, "work"));
            this.deploy = XapLocations.initFromSystemProperty("com.gs.deploy", XapLocations.path(xapHome, "deploy"));
            this.insightedge = XapLocations.path(xapHome, "insightedge");
            this.sparkHome = XapLocations.getEnvVar("SPARK_HOME", XapLocations.path(this.insightedge, "spark"));
            System.setProperty("spark.home", this.sparkHome);
        }

        private static String getEnvVar(String key, String defaultValue) {
            String result = System.getenv(key);
            return result != null ? result : defaultValue;
        }

        private static String initFromSystemProperty(String key, String defaultValue) {
            String result = System.getProperty(key);
            if (result != null) {
                return result;
            }
            System.setProperty(key, defaultValue);
            return defaultValue;
        }

        public String config() {
            return this.config;
        }

        public String work() {
            return this.work;
        }

        public String restResources() {
            return XapLocations.path(this.work, "RESTresources");
        }

        public String restJettyTempFiles() {
            return XapLocations.path(this.work, "rest-jetty");
        }

        public String sparkRestApplications() {
            return XapLocations.path(this.work, "sparkRESTApplications");
        }

        public String deploy() {
            return this.deploy;
        }

        public String xapNetHome() {
            return this.xapNetHome;
        }

        private static String path(String base, String subdir) {
            return base + File.separator + subdir;
        }

        public String bin() {
            return this.bin;
        }

        public String lib() {
            return this.lib;
        }

        public String getLibRequired() {
            return this.libRequired;
        }

        public String getLibOptional() {
            return this.libOptional;
        }

        public String getLibPlatform() {
            return this.libPlatform;
        }

        public String getLibOptionalSecurity() {
            return this.libOptionalSecurity;
        }
    }
}

